/*
 * Decompiled with CFR 0.152.
 */
package cn.starrys.tool.core.util;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONObject;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\bH\u0003J5\u0010\n\u001a\u0004\u0018\u0001H\u000b\"\u0004\b\u0000\u0010\u000b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u0002H\u000b\u0018\u00010\u000eH\u0007\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcn/starrys/tool/core/util/JsonUtils;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "split", "", "", "keyPath", "parse", "T", "jsonStr", "type", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "starry-core"})
@SourceDebugExtension(value={"SMAP\nJsonUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonUtils.kt\ncn/starrys/tool/core/util/JsonUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,72:1\n739#2,9:73\n*S KotlinDebug\n*F\n+ 1 JsonUtils.kt\ncn/starrys/tool/core/util/JsonUtils\n*L\n22#1:73,9\n*E\n"})
public final class JsonUtils {
    @NotNull
    public static final JsonUtils INSTANCE = new JsonUtils();
    @NotNull
    private static final Logger logger;

    private JsonUtils() {
    }

    @JvmStatic
    private static final List<String> split(String keyPath) {
        List list;
        CharSequence charSequence = keyPath;
        Regex regex = new Regex("\\.");
        int n = 0;
        List $this$dropLastWhile$iv = regex.split(charSequence, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @JvmStatic
    @Nullable
    public static final <T> T parse(@NotNull String jsonStr, @NotNull String keyPath, @Nullable Class<T> type) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)jsonStr, (String)"jsonStr");
        Intrinsics.checkNotNullParameter((Object)keyPath, (String)"keyPath");
        String currentJson = jsonStr;
        List<String> keys = JsonUtils.split(keyPath);
        for (String key : keys) {
            JSONObject jsonObject = JSON.parseObject((String)currentJson);
            int begin = StringsKt.indexOf$default((CharSequence)key, (char)'[', (int)0, (boolean)false, (int)6, null);
            int end = StringsKt.lastIndexOf$default((CharSequence)key, (char)']', (int)0, (boolean)false, (int)6, null);
            if (begin != -1 && end != -1) {
                Intrinsics.checkNotNullExpressionValue((Object)key.substring(0, begin), (String)"substring(...)");
                String string = key.substring(begin + 1, end);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                int i = Integer.parseInt(string);
                try {
                    String k;
                    currentJson = jsonObject.getJSONArray(k).getString(i);
                }
                catch (IndexOutOfBoundsException e) {
                    logger.error("\u6570\u7ec4\u8d8a\u754c", (Throwable)e);
                }
                continue;
            }
            currentJson = jsonObject.getString(key);
        }
        try {
            object = JSON.to(type, (Object)currentJson);
        }
        catch (JSONException e) {
            logger.error("\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
            object = null;
        }
        return (T)object;
    }

    static {
        Logger logger = LoggerFactory.getLogger(INSTANCE.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        JsonUtils.logger = logger;
    }
}

