/*
 * Decompiled with CFR 0.152.
 */
package cn.starrys.tool.core.util;

import cn.starrys.tool.core.constant.IResultStatus;
import cn.starrys.tool.core.constant.ResultStatusEnum;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u0086\b\u0018\u0000 $*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0002$%B1\b\u0002\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00018\u0000\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003\u00a2\u0006\u0002\u0010\rJ\u000b\u0010\u0019\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u0010\u0010\u001a\u001a\u0004\u0018\u00018\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0012J\t\u0010\u001b\u001a\u00020\tH\u00c6\u0003JB\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00018\u00002\b\b\u0002\u0010\b\u001a\u00020\tH\u00c2\u0001\u00a2\u0006\u0002\u0010\u001dJ\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u00d6\u0003J\t\u0010\"\u001a\u00020\u0004H\u00d6\u0001J\t\u0010#\u001a\u00020\u0006H\u00d6\u0001R\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0015\u0010\u0007\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcn/starrys/tool/core/util/Result;", "T", "Lcn/starrys/tool/core/constant/IResultStatus;", "code", "", "message", "", "data", "timestamp", "Ljava/time/Instant;", "<init>", "(Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/Object;Ljava/time/Instant;)V", "getCode", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getMessage", "()Ljava/lang/String;", "getData", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getTimestamp", "()Ljava/time/Instant;", "logger", "Lorg/slf4j/Logger;", "component1", "component2", "component3", "component4", "copy", "(Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/Object;Ljava/time/Instant;)Lcn/starrys/tool/core/util/Result;", "equals", "", "other", "", "hashCode", "toString", "Companion", "Builder", "starry-core"})
public final class Result<T>
implements IResultStatus {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Integer code;
    @Nullable
    private final String message;
    @Nullable
    private final T data;
    @NotNull
    private final Instant timestamp;
    @NotNull
    private final Logger logger;
    private static final long serialVersionUID = 4327958315156039L;

    private Result(Integer code, String message, T data, Instant timestamp) {
        this.code = code;
        this.message = message;
        this.data = data;
        this.timestamp = timestamp;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    /* synthetic */ Result(Integer n, String string, Object object, Instant instant, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            instant = Instant.now();
        }
        this(n, string, object, instant);
    }

    @Override
    @Nullable
    public Integer getCode() {
        return this.code;
    }

    @Override
    @Nullable
    public String getMessage() {
        return this.message;
    }

    @Nullable
    public final T getData() {
        return this.data;
    }

    @NotNull
    public final Instant getTimestamp() {
        return this.timestamp;
    }

    @Nullable
    public final Integer component1() {
        return this.code;
    }

    @Nullable
    public final String component2() {
        return this.message;
    }

    @Nullable
    public final T component3() {
        return this.data;
    }

    @NotNull
    public final Instant component4() {
        return this.timestamp;
    }

    private final Result<T> copy(Integer code, String message, T data, Instant timestamp) {
        return new Result<T>(code, message, data, timestamp);
    }

    static /* synthetic */ Result copy$default(Result result, Integer n, String string, Object object, Instant instant, int n2, Object object2) {
        if ((n2 & 1) != 0) {
            n = result.code;
        }
        if ((n2 & 2) != 0) {
            string = result.message;
        }
        if ((n2 & 4) != 0) {
            object = result.data;
        }
        if ((n2 & 8) != 0) {
            instant = result.timestamp;
        }
        return result.copy(n, string, object, instant);
    }

    @NotNull
    public String toString() {
        return "Result(code=" + this.code + ", message=" + this.message + ", data=" + this.data + ", timestamp=" + this.timestamp + ")";
    }

    public int hashCode() {
        int result = this.code == null ? 0 : ((Object)this.code).hashCode();
        result = result * 31 + (this.message == null ? 0 : this.message.hashCode());
        result = result * 31 + (this.data == null ? 0 : this.data.hashCode());
        result = result * 31 + this.timestamp.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Result)) {
            return false;
        }
        Result result = (Result)other;
        if (!Intrinsics.areEqual((Object)this.code, (Object)result.code)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.message, (Object)result.message)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.data, result.data)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.timestamp, (Object)result.timestamp);
    }

    @JvmStatic
    @NotNull
    public static final <T> Result<T> result(@Nullable Integer code, @Nullable String message, @Nullable T data) {
        return Companion.result(code, message, data);
    }

    @JvmStatic
    @NotNull
    public static final <T> Result<T> result(@Nullable IResultStatus resultStatus, @Nullable T data) {
        return Companion.result(resultStatus, data);
    }

    @JvmStatic
    @NotNull
    public static final <T> Result<T> success(@NotNull String message, T data) {
        return Companion.success(message, data);
    }

    @JvmStatic
    @NotNull
    public static final Result<Unit> success(@NotNull String message) {
        return Companion.success(message);
    }

    @JvmStatic
    @NotNull
    public static final <T> Result<T> success(T data) {
        return Companion.success(data);
    }

    @JvmStatic
    @NotNull
    public static final Result<Unit> success() {
        return Companion.success();
    }

    @JvmStatic
    @NotNull
    public static final Result<Unit> failure(@NotNull String message) {
        return Companion.failure(message);
    }

    @JvmStatic
    @NotNull
    public static final Result<Unit> failure() {
        return Companion.failure();
    }

    @JvmStatic
    @NotNull
    public static final Builder<Unit> builder() {
        return Companion.builder();
    }

    @JvmStatic
    @NotNull
    public static final <T> Builder<T> builder(T data) {
        return Companion.builder(data);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B\u0011\b\u0000\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010\f\u001a\u00020\rJ\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u000eJ\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00010\u0010R\u0010\u0010\u0003\u001a\u00028\u0001X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0012\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcn/starrys/tool/core/util/Result$Builder;", "T", "", "data", "<init>", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "code", "", "Ljava/lang/Integer;", "message", "", "status", "Lcn/starrys/tool/core/constant/IResultStatus;", "(Ljava/lang/Object;)Lcn/starrys/tool/core/util/Result$Builder;", "build", "Lcn/starrys/tool/core/util/Result;", "starry-core"})
    @SourceDebugExtension(value={"SMAP\nResult.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Result.kt\ncn/starrys/tool/core/util/Result$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,208:1\n1#2:209\n*E\n"})
    public static final class Builder<T> {
        private T data;
        @Nullable
        private Integer code;
        @Nullable
        private String message;

        public Builder(T data) {
            this.data = data;
        }

        @NotNull
        public final Builder<T> status(@NotNull IResultStatus status) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            Builder $this$status_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$status_u24lambda_u240.code = status.getCode();
            $this$status_u24lambda_u240.message = status.getMessage();
            return builder;
        }

        @NotNull
        public final Builder<T> code(int code) {
            Builder builder;
            Builder $this$code_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$code_u24lambda_u241.code = code;
            return builder;
        }

        @NotNull
        public final Builder<T> message(@NotNull String message) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Builder $this$message_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$message_u24lambda_u242.message = message;
            return builder;
        }

        @NotNull
        public final Builder<T> data(T data) {
            Builder builder;
            Builder $this$data_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$data_u24lambda_u243.data = data;
            return builder;
        }

        @NotNull
        public final Result<T> build() {
            return new Result(this.code, this.message, this.data, null, 8, null);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J7\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\b0\u0007\"\u0004\b\u0001\u0010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u0001H\bH\u0007\u00a2\u0006\u0002\u0010\u000eJ-\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\b0\u0007\"\u0004\b\u0001\u0010\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\r\u001a\u0004\u0018\u0001H\bH\u0007\u00a2\u0006\u0002\u0010\u0011J)\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\b0\u0007\"\u0004\b\u0001\u0010\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u0002H\bH\u0007\u00a2\u0006\u0002\u0010\u0013J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0007J!\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\b0\u0007\"\u0004\b\u0001\u0010\b2\u0006\u0010\r\u001a\u0002H\bH\u0007\u00a2\u0006\u0002\u0010\u0015J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0007H\u0007J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u0007H\u0007J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u0018H\u0007J!\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\b0\u0018\"\u0004\b\u0001\u0010\b2\u0006\u0010\r\u001a\u0002H\bH\u0007\u00a2\u0006\u0002\u0010\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcn/starrys/tool/core/util/Result$Companion;", "", "<init>", "()V", "serialVersionUID", "", "result", "Lcn/starrys/tool/core/util/Result;", "T", "code", "", "message", "", "data", "(Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/Object;)Lcn/starrys/tool/core/util/Result;", "resultStatus", "Lcn/starrys/tool/core/constant/IResultStatus;", "(Lcn/starrys/tool/core/constant/IResultStatus;Ljava/lang/Object;)Lcn/starrys/tool/core/util/Result;", "success", "(Ljava/lang/String;Ljava/lang/Object;)Lcn/starrys/tool/core/util/Result;", "", "(Ljava/lang/Object;)Lcn/starrys/tool/core/util/Result;", "failure", "builder", "Lcn/starrys/tool/core/util/Result$Builder;", "(Ljava/lang/Object;)Lcn/starrys/tool/core/util/Result$Builder;", "starry-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final <T> Result<T> result(@Nullable Integer code, @Nullable String message, @Nullable T data) {
            return new Result(code, message, data, null, 8, null);
        }

        @JvmStatic
        @NotNull
        public final <T> Result<T> result(@Nullable IResultStatus resultStatus, @Nullable T data) {
            IResultStatus iResultStatus = resultStatus;
            IResultStatus iResultStatus2 = resultStatus;
            return new Result(iResultStatus != null ? iResultStatus.getCode() : null, iResultStatus2 != null ? iResultStatus2.getMessage() : null, data, null, 8, null);
        }

        @JvmStatic
        @NotNull
        public final <T> Result<T> success(@NotNull String message, T data) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            return new Result(ResultStatusEnum.OK.getCode(), message, data, null, 8, null);
        }

        @JvmStatic
        @NotNull
        public final Result<Unit> success(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            return new Result<Unit>(ResultStatusEnum.NO_CONTENT.getCode(), message, Unit.INSTANCE, null, 8, null);
        }

        @JvmStatic
        @NotNull
        public final <T> Result<T> success(T data) {
            return new Result(ResultStatusEnum.OK.getCode(), ResultStatusEnum.OK.getMessage(), data, null, 8, null);
        }

        @JvmStatic
        @NotNull
        public final Result<Unit> success() {
            return new Result<Unit>(ResultStatusEnum.NO_CONTENT.getCode(), ResultStatusEnum.NO_CONTENT.getMessage(), Unit.INSTANCE, null, 8, null);
        }

        @JvmStatic
        @NotNull
        public final Result<Unit> failure(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            return new Result<Unit>(ResultStatusEnum.SERVICE_UNAVAILABLE.getCode(), message, Unit.INSTANCE, null, 8, null);
        }

        @JvmStatic
        @NotNull
        public final Result<Unit> failure() {
            return new Result<Unit>(ResultStatusEnum.SERVICE_UNAVAILABLE.getCode(), ResultStatusEnum.SERVICE_UNAVAILABLE.getMessage(), Unit.INSTANCE, null, 8, null);
        }

        @JvmStatic
        @NotNull
        public final Builder<Unit> builder() {
            return new Builder<Unit>(Unit.INSTANCE);
        }

        @JvmStatic
        @NotNull
        public final <T> Builder<T> builder(T data) {
            return new Builder<T>(data);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

