/*
 * Decompiled with CFR 0.152.
 */
package cn.starlightsoftware.sherly.model;

import cn.starlightsoftware.sherly.exception.BizException;
import cn.starlightsoftware.sherly.exception.IBaseError;
import cn.starlightsoftware.sherly.exception.enums.GlobalErrorCodeEnum;
import cn.starlightsoftware.sherly.exception.model.RpcExceptionModel;
import com.fasterxml.jackson.annotation.JsonIgnore;

public class Result<T> {
    private String code;
    private String message;
    private RpcExceptionModel exceptionMessage;
    private Long timestamp;
    private T data;

    public Result(T data) {
        this.code = GlobalErrorCodeEnum.SUCCESS.getCode();
        this.message = GlobalErrorCodeEnum.SUCCESS.getMessage();
        this.timestamp = System.currentTimeMillis();
        this.data = data;
    }

    public Result(String code, String message) {
        this.code = code;
        this.message = message;
        this.timestamp = System.currentTimeMillis();
    }

    public Result(String code, String message, RpcExceptionModel exceptionMessage) {
        this.code = code;
        this.message = message;
        this.exceptionMessage = exceptionMessage;
        this.timestamp = System.currentTimeMillis();
    }

    public Result(String code, String message, RpcExceptionModel exceptionMessage, T data) {
        this.code = code;
        this.message = message;
        this.exceptionMessage = exceptionMessage;
        this.timestamp = System.currentTimeMillis();
        this.data = data;
    }

    public static <T> Result<T> success(T data) {
        return new Result<T>(data);
    }

    public static Result<?> success() {
        return Result.success(null);
    }

    public static Result<?> error(IBaseError error) {
        return new Result(error.getCode(), error.getMessage());
    }

    public static Result<?> error(String message) {
        return new Result(GlobalErrorCodeEnum.UNKNOWN.getCode(), String.format(GlobalErrorCodeEnum.UNKNOWN.getMessage(), message));
    }

    public static Result<?> error(IBaseError error, String message) {
        return new Result(error.getCode(), String.format(error.getMessage(), message));
    }

    public static Result<?> error(RpcExceptionModel e) {
        return new Result(GlobalErrorCodeEnum.UNKNOWN.getCode(), String.format(GlobalErrorCodeEnum.UNKNOWN.getMessage(), e.getMessage()), e);
    }

    public static Result<?> error(BizException e) {
        return new Result(e.getCode(), e.getMessage(), e.getRpcExceptionModel());
    }

    public static <T> Result<?> error(BizException e, T data) {
        return new Result<T>(e.getCode(), e.getMessage(), e.getRpcExceptionModel(), data);
    }

    public void checkError() {
        if (this.code.equals(GlobalErrorCodeEnum.SUCCESS.getCode())) {
            return;
        }
        throw new BizException(this.code, this.message, this.exceptionMessage);
    }

    public boolean checkErrorCode() {
        return !this.code.equals(GlobalErrorCodeEnum.SUCCESS.getCode());
    }

    @JsonIgnore
    public T getCheckedData() {
        this.checkError();
        return this.data;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public RpcExceptionModel getExceptionMessage() {
        return this.exceptionMessage;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public T getData() {
        return this.data;
    }

    public Result() {
    }
}

