/*
 * Decompiled with CFR 0.152.
 */
package cn.starlightsoftware.sherly.exception;

import cn.starlightsoftware.sherly.exception.IBaseError;
import cn.starlightsoftware.sherly.exception.model.RpcExceptionModel;

public class BizException
extends RuntimeException {
    private final String code;
    private final String message;
    private RpcExceptionModel rpcExceptionModel = null;

    public BizException(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public BizException(IBaseError error) {
        this.code = error.getCode();
        this.message = error.getMessage();
    }

    public BizException(IBaseError error, Object ... args) {
        this.code = error.getCode();
        this.message = String.format(error.getMessage(), args);
    }

    public BizException(String code, String message, RpcExceptionModel rpcExceptionModel) {
        this.code = code;
        this.message = message;
        this.rpcExceptionModel = rpcExceptionModel;
    }

    public String getCode() {
        return this.code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public RpcExceptionModel getRpcExceptionModel() {
        return this.rpcExceptionModel;
    }
}

