/*
 *    Copyright 2019 The aio-socket Project
 *
 *    The aio-socket Project Licenses this file to you under the Apache License,
 *    Version 2.0 (the "License"); you may not use this file except in compliance
 *    with the License. You may obtain a copy of the License at:
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */
package cn.starboot.http.common;

import java.util.concurrent.Semaphore;

/**
 * Created by DELL(mxd) on 2022/12/30 13:21
 */
public class WriteCache {

	private final byte[] cacheData;
	private final Semaphore semaphore = new Semaphore(1);
	private long expireTime;


	public WriteCache(long cacheTime, byte[] data) {
		this.expireTime = cacheTime;
		this.cacheData = data;
	}

	public long getExpireTime() {
		return expireTime;
	}

	public void setExpireTime(long expireTime) {
		this.expireTime = expireTime;
	}

	public Semaphore getSemaphore() {
		return semaphore;
	}

	public byte[] getCacheData() {
		return cacheData;
	}

}
