/*
 * Decompiled with CFR 0.152.
 */
package cn.starboot.http.common.utils;

import cn.starboot.http.common.utils.Param;
import cn.starboot.http.common.utils.StringUtils;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Properties;
import java.util.logging.Level;

public class ParamReflect {
    private ParamReflect() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean reflect(String file, Object obj) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            boolean bl = ParamReflect.reflect(in, obj);
            return bl;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                in = null;
            }
        }
        return false;
    }

    public static boolean reflect(InputStream in, Object obj) {
        boolean flag = false;
        Properties property = new Properties();
        try {
            Field[] fileds;
            property.load(in);
            for (Field f : fileds = obj.getClass().getDeclaredFields()) {
                if (!f.isAnnotationPresent(Param.class)) continue;
                Param p = f.getAnnotation(Param.class);
                String name = p.name();
                if (StringUtils.isBlank(name)) {
                    name = f.getName();
                }
                String fieldType = f.getGenericType().toString();
                String value = property.getProperty(name, "");
                if ("".equals(value) && p.value() != null) {
                    value = p.value();
                }
                f.setAccessible(true);
                if ("int".equals(fieldType)) {
                    f.setInt(obj, Integer.parseInt(value));
                    continue;
                }
                if ("long".equals(fieldType)) {
                    f.setLong(obj, Long.parseLong(value));
                    continue;
                }
                if ("boolean".equals(fieldType)) {
                    f.setBoolean(obj, Boolean.parseBoolean(value));
                    continue;
                }
                if (f.getGenericType().equals(String.class)) {
                    f.set(obj, value);
                    continue;
                }
                if (String.class.equals(f.getType().getComponentType())) {
                    if (StringUtils.isBlank(value)) continue;
                    f.set(obj, value.split(","));
                    continue;
                }
                if (Level.class.equals((Object)f.getGenericType())) {
                    f.set(obj, Level.parse(value));
                    continue;
                }
                if (f.getType().isInterface() && !StringUtils.isBlank(value)) {
                    f.set(obj, Class.forName(value).newInstance());
                    continue;
                }
                if (f.getType().getComponentType() != null) {
                    if (StringUtils.isBlank(value)) continue;
                    String[] vals = value.split(",");
                    Object arryObj = Array.newInstance(f.getType().getComponentType(), vals.length);
                    for (int i = 0; i < vals.length; ++i) {
                        Array.set(arryObj, i, Class.forName(vals[i]).newInstance());
                    }
                    f.set(obj, arryObj);
                    continue;
                }
                throw new RuntimeException("Unsupport Type " + f.getGenericType());
            }
            flag = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }
}

