/*
 * Decompiled with CFR 0.152.
 */
package cn.starboot.http.common.io;

import cn.starboot.http.common.enums.HttpStatus;
import cn.starboot.http.common.exception.HttpException;
import cn.starboot.socket.core.ChannelContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class ChunkedInputStream
extends InputStream {
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream(8);
    private boolean readFlag = true;
    private final ChannelContext channelContext;
    private InputStream inputStream;
    private boolean eof = false;

    public ChunkedInputStream(ChannelContext channelContext) {
        this.channelContext = channelContext;
    }

    @Override
    public int read() {
        throw new UnsupportedOperationException("unsafe operation");
    }

    @Override
    public int read(byte[] data, int off, int len) throws IOException {
        this.readChunkedLength();
        if (this.eof) {
            return -1;
        }
        int i = this.inputStream.read(data, off, len);
        if (i == -1) {
            this.inputStream.close();
            this.inputStream = this.channelContext.getInputStream();
            this.readCrlf();
            this.readFlag = true;
            return this.read(data, off, len);
        }
        return i;
    }

    private void readChunkedLength() throws IOException {
        while (this.readFlag) {
            this.inputStream = this.channelContext.getInputStream();
            int b = this.inputStream.read();
            if (b == 10) {
                int length = Integer.parseInt(this.buffer.toString(), 16);
                this.buffer.reset();
                if (length == 0) {
                    this.eof = true;
                    this.readCrlf();
                    break;
                }
                this.inputStream.close();
                this.inputStream = this.channelContext.getInputStream(length);
                this.readFlag = false;
                continue;
            }
            if (b == 13) continue;
            this.buffer.write(b);
        }
    }

    private void readCrlf() throws IOException {
        if (this.inputStream.read() != 13) {
            throw new HttpException(HttpStatus.BAD_REQUEST);
        }
        if (this.inputStream.read() != 10) {
            throw new HttpException(HttpStatus.BAD_REQUEST);
        }
    }
}

