/*
 * Decompiled with CFR 0.152.
 */
package cn.starboot.mqtt.codec;

import cn.starboot.mqtt.codec.MqttReasonCode;

public class ReasonCodeUtils {
    protected static <C extends MqttReasonCode> void fillValuesByCode(C[] valuesByCode, C[] values) {
        for (C code : values) {
            int unsignedByte = code.value() & 0xFF;
            valuesByCode[unsignedByte] = code;
        }
    }

    protected static <C> C codeLoopUp(C[] valuesByCode, byte b, String codeType) {
        int unsignedByte = b & 0xFF;
        C reasonCode = null;
        try {
            reasonCode = valuesByCode[unsignedByte];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (reasonCode == null) {
            throw new IllegalArgumentException("unknown " + codeType + " reason code: " + unsignedByte);
        }
        return reasonCode;
    }
}

