/*
 * Decompiled with CFR 0.152.
 */
package cn.starboot.mqtt.codec;

import cn.starboot.mqtt.codec.MqttQoS;
import cn.starboot.mqtt.codec.MqttSubscriptionOption;

public final class MqttTopicSubscription {
    private final String topicFilter;
    private final MqttSubscriptionOption option;

    public MqttTopicSubscription(String topicFilter, MqttQoS qualityOfService) {
        this.topicFilter = topicFilter;
        this.option = MqttSubscriptionOption.onlyFromQos(qualityOfService);
    }

    public MqttTopicSubscription(String topicFilter, MqttSubscriptionOption option) {
        this.topicFilter = topicFilter;
        this.option = option;
    }

    public String topicName() {
        return this.topicFilter;
    }

    public MqttQoS qualityOfService() {
        return this.option.qos();
    }

    public MqttSubscriptionOption option() {
        return this.option;
    }

    public String toString() {
        return "MqttTopicSubscription[topicFilter=" + this.topicFilter + ", option=" + this.option + ']';
    }
}

