/*
 * Decompiled with CFR 0.152.
 */
package cn.starboot.mqtt.codec;

import cn.starboot.mqtt.codec.MqttByteBuffer;
import cn.starboot.mqtt.codec.MqttCodecUtil;
import cn.starboot.mqtt.codec.MqttConnAckMessage;
import cn.starboot.mqtt.codec.MqttConnectMessage;
import cn.starboot.mqtt.codec.MqttConnectPayload;
import cn.starboot.mqtt.codec.MqttConnectVariableHeader;
import cn.starboot.mqtt.codec.MqttFixedHeader;
import cn.starboot.mqtt.codec.MqttIdentifierRejectedException;
import cn.starboot.mqtt.codec.MqttMessage;
import cn.starboot.mqtt.codec.MqttMessageIdAndPropertiesVariableHeader;
import cn.starboot.mqtt.codec.MqttMessageIdVariableHeader;
import cn.starboot.mqtt.codec.MqttProperties;
import cn.starboot.mqtt.codec.MqttPubReplyMessageVariableHeader;
import cn.starboot.mqtt.codec.MqttPublishMessage;
import cn.starboot.mqtt.codec.MqttPublishVariableHeader;
import cn.starboot.mqtt.codec.MqttReasonCodeAndPropertiesVariableHeader;
import cn.starboot.mqtt.codec.MqttSubAckMessage;
import cn.starboot.mqtt.codec.MqttSubscribeMessage;
import cn.starboot.mqtt.codec.MqttSubscribePayload;
import cn.starboot.mqtt.codec.MqttSubscriptionOption;
import cn.starboot.mqtt.codec.MqttTopicSubscription;
import cn.starboot.mqtt.codec.MqttUnsubAckMessage;
import cn.starboot.mqtt.codec.MqttUnsubAckPayload;
import cn.starboot.mqtt.codec.MqttUnsubscribeMessage;
import cn.starboot.mqtt.codec.MqttUnsubscribePayload;
import cn.starboot.mqtt.codec.MqttVersion;
import cn.starboot.socket.codec.EncoderException;
import cn.starboot.socket.codec.util.ByteBufferUtil;
import cn.starboot.socket.core.ChannelContext;
import cn.starboot.socket.core.WriteBuffer;
import cn.starboot.socket.exception.AioEncoderException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;

public final class MqttEncoder {
    private static MqttEncoder mqttEncoder = null;

    private MqttEncoder() {
    }

    public static synchronized MqttEncoder getInstance() {
        if (Objects.isNull(mqttEncoder)) {
            mqttEncoder = new MqttEncoder();
        }
        return mqttEncoder;
    }

    public void doEncode(ChannelContext ctx, MqttMessage message) throws AioEncoderException {
        WriteBuffer writeBuffer = ctx.getWriteBuffer();
        switch (message.fixedHeader().messageType()) {
            case CONNECT: {
                MqttEncoder.encodeConnectMessage(ctx, (MqttConnectMessage)message, writeBuffer);
                break;
            }
            case CONNACK: {
                MqttEncoder.encodeConnAckMessage(ctx, (MqttConnAckMessage)message, writeBuffer);
                break;
            }
            case PUBLISH: {
                MqttEncoder.encodePublishMessage(ctx, (MqttPublishMessage)message, writeBuffer);
                break;
            }
            case SUBSCRIBE: {
                MqttEncoder.encodeSubscribeMessage(ctx, (MqttSubscribeMessage)message, writeBuffer);
                break;
            }
            case UNSUBSCRIBE: {
                MqttEncoder.encodeUnsubscribeMessage(ctx, (MqttUnsubscribeMessage)message, writeBuffer);
                break;
            }
            case SUBACK: {
                MqttEncoder.encodeSubAckMessage(ctx, (MqttSubAckMessage)message, writeBuffer);
                break;
            }
            case UNSUBACK: {
                if (message instanceof MqttUnsubAckMessage) {
                    MqttEncoder.encodeUnsubAckMessage(ctx, (MqttUnsubAckMessage)message, writeBuffer);
                }
                MqttEncoder.encodeMessageWithOnlySingleByteFixedHeaderAndMessageId(message, writeBuffer);
                break;
            }
            case PUBACK: 
            case PUBREC: 
            case PUBREL: 
            case PUBCOMP: {
                MqttEncoder.encodePubReplyMessage(ctx, message, writeBuffer);
                break;
            }
            case DISCONNECT: 
            case AUTH: {
                MqttEncoder.encodeReasonCodePlusPropertiesMessage(ctx, message, writeBuffer);
                break;
            }
            case PINGREQ: 
            case PINGRESP: {
                MqttEncoder.encodeMessageWithOnlySingleByteFixedHeader(message, writeBuffer);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown message type: " + message.fixedHeader().messageType().value());
            }
        }
    }

    private static void encodeConnectMessage(ChannelContext ctx, MqttConnectMessage message, WriteBuffer writeBuffer) throws AioEncoderException {
        byte[] willPropertiesBytes;
        byte[] password;
        byte[] passwordBytes;
        String userName;
        byte[] userNameBytes;
        byte[] willMessageBytes;
        int payloadBufferSize = 0;
        MqttFixedHeader mqttFixedHeader = message.fixedHeader();
        MqttConnectVariableHeader variableHeader = message.variableHeader();
        MqttConnectPayload payload = message.payload();
        MqttVersion mqttVersion = MqttVersion.fromProtocolNameAndLevel(variableHeader.name(), (byte)variableHeader.version());
        MqttCodecUtil.setMqttVersion(ctx, mqttVersion);
        if (!variableHeader.hasUserName() && variableHeader.hasPassword()) {
            throw new EncoderException("Without a username, the password MUST be not set");
        }
        String clientIdentifier = payload.clientIdentifier();
        if (!MqttCodecUtil.isValidClientId(mqttVersion, 64, clientIdentifier)) {
            throw new MqttIdentifierRejectedException("invalid clientIdentifier: " + clientIdentifier);
        }
        byte[] clientIdentifierBytes = MqttEncoder.encodeStringUtf8(clientIdentifier);
        payloadBufferSize += 2 + clientIdentifierBytes.length;
        String willTopic = payload.willTopic();
        byte[] willTopicBytes = willTopic != null ? MqttEncoder.encodeStringUtf8(willTopic) : ByteBufferUtil.EMPTY_BYTES;
        byte[] willMessage = payload.willMessageInBytes();
        byte[] byArray = willMessageBytes = willMessage != null ? willMessage : ByteBufferUtil.EMPTY_BYTES;
        if (variableHeader.isWillFlag()) {
            payloadBufferSize += 2 + willTopicBytes.length;
            payloadBufferSize += 2 + willMessageBytes.length;
        }
        byte[] byArray2 = userNameBytes = (userName = payload.userName()) != null ? MqttEncoder.encodeStringUtf8(userName) : ByteBufferUtil.EMPTY_BYTES;
        if (variableHeader.hasUserName()) {
            payloadBufferSize += 2 + userNameBytes.length;
        }
        byte[] byArray3 = passwordBytes = (password = payload.passwordInBytes()) != null ? password : ByteBufferUtil.EMPTY_BYTES;
        if (variableHeader.hasPassword()) {
            payloadBufferSize += 2 + passwordBytes.length;
        }
        byte[] protocolNameBytes = mqttVersion.protocolNameBytes();
        byte[] propertiesBytes = MqttEncoder.encodePropertiesIfNeeded(mqttVersion, message.variableHeader().properties());
        if (variableHeader.isWillFlag()) {
            willPropertiesBytes = MqttEncoder.encodePropertiesIfNeeded(mqttVersion, payload.willProperties());
            payloadBufferSize += propertiesBytes.length;
        } else {
            willPropertiesBytes = ByteBufferUtil.EMPTY_BYTES;
        }
        int variableHeaderBufferSize = 2 + protocolNameBytes.length + 4 + propertiesBytes.length;
        int variablePartSize = variableHeaderBufferSize + payloadBufferSize;
        int fixedHeaderBufferSize = 1 + MqttEncoder.getVariableLengthInt(variablePartSize);
        writeBuffer.write((int)((byte)MqttEncoder.getFixedHeaderByte1(mqttFixedHeader)));
        MqttEncoder.writeVariableLengthInt(writeBuffer, variablePartSize);
        writeBuffer.writeShort((short)protocolNameBytes.length);
        writeBuffer.write(protocolNameBytes);
        writeBuffer.write((int)((byte)variableHeader.version()));
        writeBuffer.write((int)((byte)MqttEncoder.getConnVariableHeaderFlag(variableHeader)));
        writeBuffer.writeShort((short)variableHeader.keepAliveTimeSeconds());
        writeBuffer.write(propertiesBytes);
        writeBuffer.writeShort((short)clientIdentifierBytes.length);
        writeBuffer.write(clientIdentifierBytes, 0, clientIdentifierBytes.length);
        if (variableHeader.isWillFlag()) {
            writeBuffer.write(willPropertiesBytes, 0, willPropertiesBytes.length);
            writeBuffer.writeShort((short)willTopicBytes.length);
            writeBuffer.write(willTopicBytes, 0, willTopicBytes.length);
            writeBuffer.writeShort((short)willMessageBytes.length);
            writeBuffer.write(willMessageBytes, 0, willMessageBytes.length);
        }
        if (variableHeader.hasUserName()) {
            writeBuffer.writeShort((short)userNameBytes.length);
            writeBuffer.write(userNameBytes, 0, userNameBytes.length);
        }
        if (variableHeader.hasPassword()) {
            writeBuffer.writeShort((short)passwordBytes.length);
            writeBuffer.write(passwordBytes, 0, passwordBytes.length);
        }
    }

    private static int getConnVariableHeaderFlag(MqttConnectVariableHeader variableHeader) {
        int flagByte = 0;
        if (variableHeader.hasUserName()) {
            flagByte |= 0x80;
        }
        if (variableHeader.hasPassword()) {
            flagByte |= 0x40;
        }
        if (variableHeader.isWillRetain()) {
            flagByte |= 0x20;
        }
        flagByte |= (variableHeader.willQos() & 3) << 3;
        if (variableHeader.isWillFlag()) {
            flagByte |= 4;
        }
        if (variableHeader.isCleanSession()) {
            flagByte |= 2;
        }
        return flagByte;
    }

    private static void encodeConnAckMessage(ChannelContext ctx, MqttConnAckMessage message, WriteBuffer writeBuffer) throws AioEncoderException {
        MqttVersion mqttVersion = MqttCodecUtil.getMqttVersion(ctx);
        byte[] propertiesBytes = MqttEncoder.encodePropertiesIfNeeded(mqttVersion, message.variableHeader().properties());
        writeBuffer.write((int)((byte)MqttEncoder.getFixedHeaderByte1(message.fixedHeader())));
        MqttEncoder.writeVariableLengthInt(writeBuffer, 2 + propertiesBytes.length);
        writeBuffer.write((int)((byte)(message.variableHeader().isSessionPresent() ? 1 : 0)));
        writeBuffer.write((int)message.variableHeader().connectReturnCode().value());
        writeBuffer.write(propertiesBytes);
    }

    private static void encodeSubscribeMessage(ChannelContext ctx, MqttSubscribeMessage message, WriteBuffer writeBuffer) throws AioEncoderException {
        MqttVersion mqttVersion = MqttCodecUtil.getMqttVersion(ctx);
        byte[] propertiesBytes = MqttEncoder.encodePropertiesIfNeeded(mqttVersion, message.idAndPropertiesVariableHeader().properties());
        int variableHeaderBufferSize = 2 + propertiesBytes.length;
        int payloadBufferSize = 0;
        MqttFixedHeader mqttFixedHeader = message.fixedHeader();
        MqttMessageIdVariableHeader variableHeader = message.variableHeader();
        MqttSubscribePayload payload = message.payload();
        for (MqttTopicSubscription topic : payload.topicSubscriptions()) {
            String topicName = topic.topicName();
            byte[] topicNameBytes = MqttEncoder.encodeStringUtf8(topicName);
            payloadBufferSize += 2 + topicNameBytes.length;
            ++payloadBufferSize;
        }
        int variablePartSize = variableHeaderBufferSize + payloadBufferSize;
        int fixedHeaderBufferSize = 1 + MqttEncoder.getVariableLengthInt(variablePartSize);
        writeBuffer.write((int)((byte)MqttEncoder.getFixedHeaderByte1(mqttFixedHeader)));
        MqttEncoder.writeVariableLengthInt(writeBuffer, variablePartSize);
        int messageId = variableHeader.messageId();
        writeBuffer.writeShort((short)messageId);
        writeBuffer.write(propertiesBytes);
        for (MqttTopicSubscription topic : payload.topicSubscriptions()) {
            String topicName = topic.topicName();
            byte[] topicNameBytes = MqttEncoder.encodeStringUtf8(topicName);
            writeBuffer.writeShort((short)topicNameBytes.length);
            writeBuffer.write(topicNameBytes, 0, topicNameBytes.length);
            if (mqttVersion == MqttVersion.MQTT_3_1_1 || mqttVersion == MqttVersion.MQTT_3_1) {
                writeBuffer.write((int)((byte)topic.qualityOfService().value()));
                continue;
            }
            MqttSubscriptionOption option = topic.option();
            int optionEncoded = option.retainHandling().value() << 4;
            if (option.isRetainAsPublished()) {
                optionEncoded |= 8;
            }
            if (option.isNoLocal()) {
                optionEncoded |= 4;
            }
            writeBuffer.write((int)((byte)(optionEncoded |= option.qos().value())));
        }
    }

    private static void encodeUnsubscribeMessage(ChannelContext ctx, MqttUnsubscribeMessage message, WriteBuffer writeBuffer) throws AioEncoderException {
        MqttVersion mqttVersion = MqttCodecUtil.getMqttVersion(ctx);
        byte[] propertiesBytes = MqttEncoder.encodePropertiesIfNeeded(mqttVersion, message.idAndPropertiesVariableHeader().properties());
        int variableHeaderBufferSize = 2 + propertiesBytes.length;
        int payloadBufferSize = 0;
        MqttFixedHeader mqttFixedHeader = message.fixedHeader();
        MqttMessageIdVariableHeader variableHeader = message.variableHeader();
        MqttUnsubscribePayload payload = message.payload();
        for (String topicName : payload.topics()) {
            byte[] topicNameBytes = MqttEncoder.encodeStringUtf8(topicName);
            payloadBufferSize += 2 + topicNameBytes.length;
        }
        int variablePartSize = variableHeaderBufferSize + payloadBufferSize;
        int fixedHeaderBufferSize = 1 + MqttEncoder.getVariableLengthInt(variablePartSize);
        writeBuffer.write((int)((byte)MqttEncoder.getFixedHeaderByte1(mqttFixedHeader)));
        MqttEncoder.writeVariableLengthInt(writeBuffer, variablePartSize);
        int messageId = variableHeader.messageId();
        writeBuffer.writeShort((short)messageId);
        writeBuffer.write(propertiesBytes);
        for (String topicName : payload.topics()) {
            byte[] topicNameBytes = MqttEncoder.encodeStringUtf8(topicName);
            writeBuffer.writeShort((short)topicNameBytes.length);
            writeBuffer.write(topicNameBytes, 0, topicNameBytes.length);
        }
    }

    private static void encodeSubAckMessage(ChannelContext ctx, MqttSubAckMessage message, WriteBuffer writeBuffer) throws AioEncoderException {
        MqttVersion mqttVersion = MqttCodecUtil.getMqttVersion(ctx);
        byte[] propertiesBytes = MqttEncoder.encodePropertiesIfNeeded(mqttVersion, message.idAndPropertiesVariableHeader().properties());
        int variableHeaderBufferSize = 2 + propertiesBytes.length;
        int payloadBufferSize = message.payload().grantedQoSLevels().size();
        int variablePartSize = variableHeaderBufferSize + payloadBufferSize;
        int fixedHeaderBufferSize = 1 + MqttEncoder.getVariableLengthInt(variablePartSize);
        writeBuffer.write((int)((byte)MqttEncoder.getFixedHeaderByte1(message.fixedHeader())));
        MqttEncoder.writeVariableLengthInt(writeBuffer, variablePartSize);
        writeBuffer.writeShort((short)message.variableHeader().messageId());
        writeBuffer.write(propertiesBytes);
        for (int code : message.payload().reasonCodes()) {
            writeBuffer.write((int)((byte)code));
        }
    }

    private static void encodeUnsubAckMessage(ChannelContext ctx, MqttUnsubAckMessage message, WriteBuffer writeBuffer) throws AioEncoderException {
        if (message.variableHeader() instanceof MqttMessageIdAndPropertiesVariableHeader) {
            MqttVersion mqttVersion = MqttCodecUtil.getMqttVersion(ctx);
            byte[] propertiesBytes = MqttEncoder.encodePropertiesIfNeeded(mqttVersion, message.idAndPropertiesVariableHeader().properties());
            int variableHeaderBufferSize = 2 + propertiesBytes.length;
            MqttUnsubAckPayload payload = message.payload();
            int payloadBufferSize = payload == null ? 0 : payload.unsubscribeReasonCodes().size();
            int variablePartSize = variableHeaderBufferSize + payloadBufferSize;
            int fixedHeaderBufferSize = 1 + MqttEncoder.getVariableLengthInt(variablePartSize);
            writeBuffer.write((int)((byte)MqttEncoder.getFixedHeaderByte1(message.fixedHeader())));
            MqttEncoder.writeVariableLengthInt(writeBuffer, variablePartSize);
            writeBuffer.writeShort((short)message.variableHeader().messageId());
            writeBuffer.write(propertiesBytes);
            if (payload != null) {
                for (Short reasonCode : payload.unsubscribeReasonCodes()) {
                    writeBuffer.writeShort(reasonCode.shortValue());
                }
            }
        } else {
            MqttEncoder.encodeMessageWithOnlySingleByteFixedHeaderAndMessageId(message, writeBuffer);
        }
    }

    private static void encodePublishMessage(ChannelContext ctx, MqttPublishMessage message, WriteBuffer writeBuffer) throws AioEncoderException {
        MqttVersion mqttVersion = MqttCodecUtil.getMqttVersion(ctx);
        MqttFixedHeader mqttFixedHeader = message.fixedHeader();
        MqttPublishVariableHeader variableHeader = message.variableHeader();
        ByteBuffer payload = message.payload().duplicate();
        String topicName = variableHeader.topicName();
        byte[] topicNameBytes = MqttEncoder.encodeStringUtf8(topicName);
        byte[] propertiesBytes = MqttEncoder.encodePropertiesIfNeeded(mqttVersion, message.variableHeader().properties());
        int variableHeaderBufferSize = 2 + topicNameBytes.length + (mqttFixedHeader.qosLevel().value() > 0 ? 2 : 0) + propertiesBytes.length;
        int payloadBufferSize = payload.array().length;
        int variablePartSize = variableHeaderBufferSize + payloadBufferSize;
        int fixedHeaderBufferSize = 1 + MqttEncoder.getVariableLengthInt(variablePartSize);
        writeBuffer.write((int)((byte)MqttEncoder.getFixedHeaderByte1(mqttFixedHeader)));
        MqttEncoder.writeVariableLengthInt(writeBuffer, variablePartSize);
        writeBuffer.writeShort((short)topicNameBytes.length);
        writeBuffer.write(topicNameBytes);
        if (mqttFixedHeader.qosLevel().value() > 0) {
            writeBuffer.writeShort((short)variableHeader.packetId());
        }
        writeBuffer.write(propertiesBytes);
        writeBuffer.write(payload.array());
    }

    private static void encodePubReplyMessage(ChannelContext ctx, MqttMessage message, WriteBuffer writeBuffer) throws AioEncoderException {
        if (message.variableHeader() instanceof MqttPubReplyMessageVariableHeader) {
            int variableHeaderBufferSize;
            boolean includeReasonCode;
            byte[] propertiesBytes;
            MqttFixedHeader mqttFixedHeader = message.fixedHeader();
            MqttPubReplyMessageVariableHeader variableHeader = (MqttPubReplyMessageVariableHeader)message.variableHeader();
            MqttVersion mqttVersion = MqttCodecUtil.getMqttVersion(ctx);
            if (!(mqttVersion != MqttVersion.MQTT_5 || variableHeader.reasonCode() == 0 && variableHeader.properties().isEmpty())) {
                propertiesBytes = MqttEncoder.encodeProperties(variableHeader.properties());
                includeReasonCode = true;
                variableHeaderBufferSize = 3 + propertiesBytes.length;
            } else {
                propertiesBytes = ByteBufferUtil.EMPTY_BYTES;
                includeReasonCode = false;
                variableHeaderBufferSize = 2;
            }
            int fixedHeaderBufferSize = 1 + MqttEncoder.getVariableLengthInt(variableHeaderBufferSize);
            writeBuffer.write((int)((byte)MqttEncoder.getFixedHeaderByte1(mqttFixedHeader)));
            MqttEncoder.writeVariableLengthInt(writeBuffer, variableHeaderBufferSize);
            writeBuffer.writeShort((short)variableHeader.messageId());
            if (includeReasonCode) {
                writeBuffer.write((int)variableHeader.reasonCode());
            }
            writeBuffer.write(propertiesBytes);
        } else {
            MqttEncoder.encodeMessageWithOnlySingleByteFixedHeaderAndMessageId(message, writeBuffer);
        }
    }

    private static void encodeMessageWithOnlySingleByteFixedHeaderAndMessageId(MqttMessage message, WriteBuffer writeBuffer) throws AioEncoderException {
        MqttFixedHeader mqttFixedHeader = message.fixedHeader();
        MqttMessageIdVariableHeader variableHeader = (MqttMessageIdVariableHeader)message.variableHeader();
        int variableHeaderBufferSize = 2;
        int fixedHeaderBufferSize = 1 + MqttEncoder.getVariableLengthInt(variableHeaderBufferSize);
        writeBuffer.write((int)((byte)MqttEncoder.getFixedHeaderByte1(mqttFixedHeader)));
        MqttEncoder.writeVariableLengthInt(writeBuffer, variableHeaderBufferSize);
        writeBuffer.writeShort((short)variableHeader.messageId());
    }

    private static void encodeReasonCodePlusPropertiesMessage(ChannelContext ctx, MqttMessage message, WriteBuffer writeBuffer) throws AioEncoderException {
        if (message.variableHeader() instanceof MqttReasonCodeAndPropertiesVariableHeader) {
            int variableHeaderBufferSize;
            boolean includeReasonCode;
            byte[] propertiesBytes;
            MqttVersion mqttVersion = MqttCodecUtil.getMqttVersion(ctx);
            MqttFixedHeader mqttFixedHeader = message.fixedHeader();
            MqttReasonCodeAndPropertiesVariableHeader variableHeader = (MqttReasonCodeAndPropertiesVariableHeader)message.variableHeader();
            if (!(mqttVersion != MqttVersion.MQTT_5 || variableHeader.reasonCode() == 0 && variableHeader.properties().isEmpty())) {
                propertiesBytes = MqttEncoder.encodeProperties(variableHeader.properties());
                includeReasonCode = true;
                variableHeaderBufferSize = 1 + propertiesBytes.length;
            } else {
                propertiesBytes = ByteBufferUtil.EMPTY_BYTES;
                includeReasonCode = false;
                variableHeaderBufferSize = 0;
            }
            int fixedHeaderBufferSize = 1 + MqttEncoder.getVariableLengthInt(variableHeaderBufferSize);
            writeBuffer.write((int)((byte)MqttEncoder.getFixedHeaderByte1(mqttFixedHeader)));
            MqttEncoder.writeVariableLengthInt(writeBuffer, variableHeaderBufferSize);
            if (includeReasonCode) {
                writeBuffer.write((int)variableHeader.reasonCode());
            }
            writeBuffer.write(propertiesBytes);
        } else {
            MqttEncoder.encodeMessageWithOnlySingleByteFixedHeader(message, writeBuffer);
        }
    }

    private static void encodeMessageWithOnlySingleByteFixedHeader(MqttMessage message, WriteBuffer writeBuffer) {
        MqttFixedHeader mqttFixedHeader = message.fixedHeader();
        writeBuffer.write((int)((byte)MqttEncoder.getFixedHeaderByte1(mqttFixedHeader)));
        writeBuffer.write(0);
    }

    private static byte[] encodePropertiesIfNeeded(MqttVersion mqttVersion, MqttProperties mqttProperties) {
        if (mqttVersion == MqttVersion.MQTT_5) {
            return MqttEncoder.encodeProperties(mqttProperties);
        }
        return ByteBufferUtil.EMPTY_BYTES;
    }

    private static byte[] encodeProperties(MqttProperties mqttProperties) {
        MqttByteBuffer mqttByteBuffer = new MqttByteBuffer();
        block9: for (MqttProperties.MqttProperty mqttProperty : mqttProperties.listAll()) {
            MqttProperties.MqttPropertyType propertyType = MqttProperties.MqttPropertyType.valueOf(mqttProperty.propertyId);
            switch (propertyType) {
                case PAYLOAD_FORMAT_INDICATOR: 
                case REQUEST_PROBLEM_INFORMATION: 
                case REQUEST_RESPONSE_INFORMATION: 
                case MAXIMUM_QOS: 
                case RETAIN_AVAILABLE: 
                case WILDCARD_SUBSCRIPTION_AVAILABLE: 
                case SUBSCRIPTION_IDENTIFIER_AVAILABLE: 
                case SHARED_SUBSCRIPTION_AVAILABLE: {
                    mqttByteBuffer.writeVarLengthInt(mqttProperty.propertyId);
                    byte bytePropValue = ((Integer)((MqttProperties.IntegerProperty)mqttProperty).value).byteValue();
                    mqttByteBuffer.writeByte(bytePropValue);
                    break;
                }
                case SERVER_KEEP_ALIVE: 
                case RECEIVE_MAXIMUM: 
                case TOPIC_ALIAS_MAXIMUM: 
                case TOPIC_ALIAS: {
                    mqttByteBuffer.writeVarLengthInt(mqttProperty.propertyId);
                    short twoBytesInPropValue = ((Integer)((MqttProperties.IntegerProperty)mqttProperty).value).shortValue();
                    mqttByteBuffer.writeShort(twoBytesInPropValue);
                    break;
                }
                case PUBLICATION_EXPIRY_INTERVAL: 
                case SESSION_EXPIRY_INTERVAL: 
                case WILL_DELAY_INTERVAL: 
                case MAXIMUM_PACKET_SIZE: {
                    mqttByteBuffer.writeVarLengthInt(mqttProperty.propertyId);
                    int fourBytesIntPropValue = (Integer)((MqttProperties.IntegerProperty)mqttProperty).value;
                    mqttByteBuffer.writeInt(fourBytesIntPropValue);
                    break;
                }
                case SUBSCRIPTION_IDENTIFIER: {
                    mqttByteBuffer.writeVarLengthInt(mqttProperty.propertyId);
                    int vbi = (Integer)((MqttProperties.IntegerProperty)mqttProperty).value;
                    mqttByteBuffer.writeVarLengthInt(vbi);
                    break;
                }
                case CONTENT_TYPE: 
                case RESPONSE_TOPIC: 
                case ASSIGNED_CLIENT_IDENTIFIER: 
                case AUTHENTICATION_METHOD: 
                case RESPONSE_INFORMATION: 
                case SERVER_REFERENCE: 
                case REASON_STRING: {
                    mqttByteBuffer.writeVarLengthInt(mqttProperty.propertyId);
                    MqttEncoder.writeEagerUTF8String(mqttByteBuffer, (String)((MqttProperties.StringProperty)mqttProperty).value);
                    break;
                }
                case USER_PROPERTY: {
                    List pairs = (List)((MqttProperties.UserProperties)mqttProperty).value;
                    for (MqttProperties.StringPair pair : pairs) {
                        mqttByteBuffer.writeVarLengthInt(mqttProperty.propertyId);
                        MqttEncoder.writeEagerUTF8String(mqttByteBuffer, pair.key);
                        MqttEncoder.writeEagerUTF8String(mqttByteBuffer, pair.value);
                    }
                    continue block9;
                }
                case CORRELATION_DATA: 
                case AUTHENTICATION_DATA: {
                    mqttByteBuffer.writeVarLengthInt(mqttProperty.propertyId);
                    byte[] binaryPropValue = (byte[])((MqttProperties.BinaryProperty)mqttProperty).value;
                    mqttByteBuffer.writeShort((short)binaryPropValue.length);
                    mqttByteBuffer.writeBytes(binaryPropValue, 0, binaryPropValue.length);
                    break;
                }
                default: {
                    throw new EncoderException("Unknown property type: " + (Object)((Object)propertyType));
                }
            }
        }
        byte[] propertiesBytes = mqttByteBuffer.toArray();
        mqttByteBuffer.reset();
        mqttByteBuffer.writeVarLengthInt(propertiesBytes.length);
        mqttByteBuffer.writeBytes(propertiesBytes);
        return mqttByteBuffer.toArray();
    }

    private static int getFixedHeaderByte1(MqttFixedHeader header) {
        int ret = 0;
        ret |= header.messageType().value() << 4;
        if (header.isDup()) {
            ret |= 8;
        }
        ret |= header.qosLevel().value() << 1;
        if (header.isRetain()) {
            ret |= 1;
        }
        return ret;
    }

    private static void writeVariableLengthInt(WriteBuffer writeBuffer, int num) {
        do {
            int digit = num % 128;
            if ((num /= 128) > 0) {
                digit |= 0x80;
            }
            writeBuffer.write((int)((byte)digit));
        } while (num > 0);
    }

    private static int getVariableLengthInt(int num) {
        int count = 0;
        do {
            ++count;
        } while ((num /= 128) > 0);
        return count;
    }

    private static void writeEagerUTF8String(MqttByteBuffer mqttByteBuffer, String s) {
        if (s == null) {
            mqttByteBuffer.writeShort((short)0);
        } else {
            byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
            mqttByteBuffer.writeShort((short)bytes.length);
            mqttByteBuffer.writeBytes(bytes);
        }
    }

    private static byte[] encodeStringUtf8(String s) {
        return s.getBytes(StandardCharsets.UTF_8);
    }
}

