/*
 * Decompiled with CFR 0.152.
 */
package cn.starboot.mqtt.codec;

import cn.starboot.socket.utils.hutool.FastByteBuffer;
import java.nio.ByteBuffer;

public class MqttByteBuffer {
    private final FastByteBuffer buffer;

    public MqttByteBuffer() {
        this(new FastByteBuffer());
    }

    public MqttByteBuffer(int size) {
        this(new FastByteBuffer(size));
    }

    public MqttByteBuffer(FastByteBuffer buffer) {
        this.buffer = buffer;
    }

    public void writeByte(byte b) {
        this.buffer.append(b);
    }

    public void writeBytes(byte[] bytes) {
        this.buffer.append(bytes);
    }

    public void writeBytes(byte[] bytes, int off, int len) {
        this.buffer.append(bytes, off, len);
    }

    public void writeShort(short v) {
        byte[] bytes = new byte[]{(byte)(v >>> 8 & 0xFF), (byte)(v & 0xFF)};
        this.buffer.append(bytes);
    }

    public void writeInt(int v) {
        byte[] bytes = new byte[]{(byte)(v >>> 24 & 0xFF), (byte)(v >>> 16 & 0xFF), (byte)(v >>> 8 & 0xFF), (byte)(v & 0xFF)};
        this.buffer.append(bytes);
    }

    public void writeLong(long v) {
        byte[] bytes = new byte[]{(byte)(v >>> 56 & 0xFFL), (byte)(v >>> 48 & 0xFFL), (byte)(v >>> 40 & 0xFFL), (byte)(v >>> 32 & 0xFFL), (byte)(v >>> 24 & 0xFFL), (byte)(v >>> 16 & 0xFFL), (byte)(v >>> 8 & 0xFFL), (byte)(v & 0xFFL)};
        this.buffer.append(bytes);
    }

    public void writeVarLengthInt(int num) {
        do {
            int digit = num % 128;
            if ((num /= 128) > 0) {
                digit |= 0x80;
            }
            this.writeByte((byte)digit);
        } while (num > 0);
    }

    public byte[] toArray() {
        return this.buffer.toArray();
    }

    public ByteBuffer toBuffer() {
        return ByteBuffer.wrap(this.toArray());
    }

    public void reset() {
        this.buffer.reset();
    }

    public int size() {
        return this.buffer.size();
    }
}

