/*
 * Decompiled with CFR 0.152.
 */
package cn.starboot.mqtt.codec;

import cn.starboot.mqtt.codec.MqttConnAckMessage;
import cn.starboot.mqtt.codec.MqttConnAckVariableHeader;
import cn.starboot.mqtt.codec.MqttConnectMessage;
import cn.starboot.mqtt.codec.MqttConnectPayload;
import cn.starboot.mqtt.codec.MqttConnectVariableHeader;
import cn.starboot.mqtt.codec.MqttFixedHeader;
import cn.starboot.mqtt.codec.MqttMessage;
import cn.starboot.mqtt.codec.MqttMessageIdVariableHeader;
import cn.starboot.mqtt.codec.MqttPubAckMessage;
import cn.starboot.mqtt.codec.MqttPublishMessage;
import cn.starboot.mqtt.codec.MqttPublishVariableHeader;
import cn.starboot.mqtt.codec.MqttSubAckMessage;
import cn.starboot.mqtt.codec.MqttSubAckPayload;
import cn.starboot.mqtt.codec.MqttSubscribeMessage;
import cn.starboot.mqtt.codec.MqttSubscribePayload;
import cn.starboot.mqtt.codec.MqttUnsubAckMessage;
import cn.starboot.mqtt.codec.MqttUnsubAckPayload;
import cn.starboot.mqtt.codec.MqttUnsubscribeMessage;
import cn.starboot.mqtt.codec.MqttUnsubscribePayload;
import cn.starboot.socket.codec.DecoderResult;
import java.nio.ByteBuffer;

public final class MqttMessageFactory {
    public static MqttMessage newMessage(MqttFixedHeader mqttFixedHeader, Object variableHeader, Object payload) {
        switch (mqttFixedHeader.messageType()) {
            case CONNECT: {
                return new MqttConnectMessage(mqttFixedHeader, (MqttConnectVariableHeader)variableHeader, (MqttConnectPayload)payload);
            }
            case CONNACK: {
                return new MqttConnAckMessage(mqttFixedHeader, (MqttConnAckVariableHeader)variableHeader);
            }
            case SUBSCRIBE: {
                return new MqttSubscribeMessage(mqttFixedHeader, (MqttMessageIdVariableHeader)variableHeader, (MqttSubscribePayload)payload);
            }
            case SUBACK: {
                return new MqttSubAckMessage(mqttFixedHeader, (MqttMessageIdVariableHeader)variableHeader, (MqttSubAckPayload)payload);
            }
            case UNSUBACK: {
                return new MqttUnsubAckMessage(mqttFixedHeader, (MqttMessageIdVariableHeader)variableHeader, (MqttUnsubAckPayload)payload);
            }
            case UNSUBSCRIBE: {
                return new MqttUnsubscribeMessage(mqttFixedHeader, (MqttMessageIdVariableHeader)variableHeader, (MqttUnsubscribePayload)payload);
            }
            case PUBLISH: {
                return new MqttPublishMessage(mqttFixedHeader, (MqttPublishVariableHeader)variableHeader, (ByteBuffer)payload);
            }
            case PUBACK: {
                return new MqttPubAckMessage(mqttFixedHeader, (MqttMessageIdVariableHeader)variableHeader);
            }
            case PUBREC: 
            case PUBREL: 
            case PUBCOMP: {
                return new MqttMessage(mqttFixedHeader, variableHeader);
            }
            case PINGREQ: 
            case PINGRESP: {
                return new MqttMessage(mqttFixedHeader);
            }
            case DISCONNECT: 
            case AUTH: {
                return new MqttMessage(mqttFixedHeader, variableHeader);
            }
        }
        throw new IllegalArgumentException("unknown message type: " + (Object)((Object)mqttFixedHeader.messageType()));
    }

    public static MqttMessage newInvalidMessage(Throwable cause) {
        return new MqttMessage(null, null, null, DecoderResult.failure((Throwable)cause));
    }

    public static MqttMessage newInvalidMessage(MqttFixedHeader mqttFixedHeader, Object variableHeader, Throwable cause) {
        return new MqttMessage(mqttFixedHeader, variableHeader, null, DecoderResult.failure((Throwable)cause));
    }

    private MqttMessageFactory() {
    }
}

