/*
 * Decompiled with CFR 0.152.
 */
package cn.starboot.mqtt.codec;

import cn.starboot.mqtt.codec.MqttProperties;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public final class MqttConnectPayload {
    private final String clientIdentifier;
    private final MqttProperties willProperties;
    private final String willTopic;
    private final byte[] willMessage;
    private final String userName;
    private final byte[] password;

    public MqttConnectPayload(String clientIdentifier, String willTopic, byte[] willMessage, String userName, byte[] password) {
        this(clientIdentifier, MqttProperties.NO_PROPERTIES, willTopic, willMessage, userName, password);
    }

    public MqttConnectPayload(String clientIdentifier, MqttProperties willProperties, String willTopic, byte[] willMessage, String userName, byte[] password) {
        this.clientIdentifier = clientIdentifier;
        this.willProperties = MqttProperties.withEmptyDefaults(willProperties);
        this.willTopic = willTopic;
        this.willMessage = willMessage;
        this.userName = userName;
        this.password = password;
    }

    public String clientIdentifier() {
        return this.clientIdentifier;
    }

    public MqttProperties willProperties() {
        return this.willProperties;
    }

    public String willTopic() {
        return this.willTopic;
    }

    public byte[] willMessageInBytes() {
        return this.willMessage;
    }

    public String userName() {
        return this.userName;
    }

    public byte[] passwordInBytes() {
        return this.password;
    }

    public String password() {
        return this.password == null ? null : new String(this.password, StandardCharsets.UTF_8);
    }

    public String toString() {
        return "MqttConnectPayload[clientIdentifier=" + this.clientIdentifier + ", willTopic=" + this.willTopic + ", willMessage=" + Arrays.toString(this.willMessage) + ", userName=" + this.userName + ", password=" + Arrays.toString(this.password) + ']';
    }
}

