/*
 * Decompiled with CFR 0.152.
 */
package cn.starboot.mqtt.codec;

import cn.starboot.mqtt.codec.MqttMessageIdAndPropertiesVariableHeader;
import cn.starboot.mqtt.codec.MqttProperties;

public class MqttMessageIdVariableHeader {
    private final int messageId;

    public static MqttMessageIdVariableHeader from(int messageId) {
        if (messageId < 1 || messageId > 65535) {
            throw new IllegalArgumentException("messageId: " + messageId + " (expected: 1 ~ 65535)");
        }
        return new MqttMessageIdVariableHeader(messageId);
    }

    protected MqttMessageIdVariableHeader(int messageId) {
        this.messageId = messageId;
    }

    public int messageId() {
        return this.messageId;
    }

    public String toString() {
        return "MqttMessageIdVariableHeader[messageId=" + this.messageId + ']';
    }

    public MqttMessageIdAndPropertiesVariableHeader withEmptyProperties() {
        return new MqttMessageIdAndPropertiesVariableHeader(this.messageId, MqttProperties.NO_PROPERTIES);
    }

    MqttMessageIdAndPropertiesVariableHeader withDefaultEmptyProperties() {
        return this.withEmptyProperties();
    }
}

