/*
 * Decompiled with CFR 0.152.
 */
package cn.sskxyz.mybatis.batch;

import cn.sskxyz.mybatis.batch.ExplicitMapper;
import cn.sskxyz.mybatis.batch.SQLBatcher;
import java.util.List;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;

public class BatchHelper {
    private SqlSessionFactory sessionFactory;

    public BatchHelper(SqlSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void batchInsert(Class<? extends SQLBatcher> mapperClass, ExplicitMapper explicitMapper, List<T> data, int batchSize) {
        if (data != null && data.size() > 0) {
            try (SqlSession session = this.sessionFactory.openSession(ExecutorType.BATCH, false);){
                SQLBatcher mapper = (SQLBatcher)session.getMapper(mapperClass);
                int i = 0;
                while (i < data.size()) {
                    explicitMapper.insertSingleData(mapper, data.get(i++));
                    if (i % batchSize != 0) continue;
                    session.commit();
                }
                if (data.size() % batchSize != 0) {
                    session.commit();
                }
            }
        }
    }
}

