/*
 * Decompiled with CFR 0.152.
 */
package cn.sskxyz.mybatis;

import cn.sskxyz.mybatis.PageContext;
import cn.sskxyz.mybatis.dialect.MysqlPageDialect;
import cn.sskxyz.mybatis.dialect.PageDialect;
import cn.sskxyz.mybatis.mode.Page;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.builder.StaticSqlSource;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class}), @Signature(type=ParameterHandler.class, method="setParameters", args={PreparedStatement.class})})
public class PagePlugin
implements Interceptor {
    private ThreadLocal<PageContext> pageContextHolder = new ThreadLocal();
    private PageDialect pageDialect;

    public Object intercept(Invocation invocation) throws Throwable {
        PageContext context;
        if ("query".equals(invocation.getMethod().getName())) {
            Map daoArgs;
            Object daoArgObj = invocation.getArgs()[1];
            Object pageObj = null;
            if (daoArgObj instanceof Page) {
                pageObj = daoArgObj;
            } else if (daoArgObj instanceof Map && (daoArgs = (Map)daoArgObj) != null && daoArgs.size() > 0) {
                pageObj = daoArgs.values().stream().filter(obj -> obj instanceof Page).findFirst().orElse(null);
            }
            if (pageObj != null) {
                MappedStatement ms = (MappedStatement)invocation.getArgs()[0];
                Object parameterObj = invocation.getArgs()[1];
                Object rowBounds = invocation.getArgs()[2];
                Object resultHandler = invocation.getArgs()[3];
                Configuration configuration = ms.getConfiguration();
                BoundSql boundSql = ms.getBoundSql(parameterObj);
                String countSql = this.pageDialect.countSql(boundSql.getSql());
                PageContext context2 = new PageContext();
                context2.setPage((Page)pageObj);
                context2.setCountSql(countSql);
                this.pageContextHolder.set(context2);
                String pageSql = this.pageDialect.pageSql(boundSql.getSql(), context2.getPage());
                StaticSqlSource sqlSource = new StaticSqlSource(configuration, pageSql, boundSql.getParameterMappings());
                MappedStatement.Builder builder = new MappedStatement.Builder(configuration, ms.getId(), (SqlSource)sqlSource, ms.getSqlCommandType());
                builder.resultMaps(ms.getResultMaps());
                builder.cache(ms.getCache());
                builder.databaseId(ms.getDatabaseId());
                builder.fetchSize(ms.getFetchSize());
                builder.resource(ms.getResource());
                return invocation.getMethod().invoke(invocation.getTarget(), builder.build(), parameterObj, rowBounds, resultHandler);
            }
        }
        if ("prepare".equals(invocation.getMethod().getName()) && (context = this.pageContextHolder.get()) != null) {
            Connection connection = (Connection)invocation.getArgs()[0];
            PreparedStatement pstmt = connection.prepareStatement(context.getCountSql());
            context.setPreparedStatement(pstmt);
        }
        if ("setParameters".equals(invocation.getMethod().getName()) && (context = this.pageContextHolder.get()) != null) {
            PreparedStatement preparedStatement = context.getPreparedStatement();
            ParameterHandler parameterHandler = (ParameterHandler)invocation.getTarget();
            parameterHandler.setParameters(preparedStatement);
            ResultSet rs = preparedStatement.executeQuery();
            if (rs.next()) {
                long total = rs.getLong(1);
                context.getPage().setTotal(total);
            }
            rs.close();
            preparedStatement.close();
            this.pageContextHolder.remove();
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
        this.pageDialect = new MysqlPageDialect();
    }
}

