/*
 * Decompiled with CFR 0.152.
 */
package cn.srclink.service.plugin;

import cn.srclink.service.plugin.PluginClassLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.stream.Stream;

public class MultiPluginClassLoaderImpl
extends PluginClassLoader {
    private final List<PluginClassLoader> loaderList;

    public MultiPluginClassLoaderImpl(PluginClassLoader ... loader) {
        this.loaderList = List.of(loader);
        this.reload();
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        for (PluginClassLoader loader : this.loaderList) {
            try {
                return loader.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    public URL getResource(String name) {
        for (PluginClassLoader loader : this.loaderList) {
            URL url = loader.getResource(name);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Vector<URL> urls = new Vector<URL>();
        for (PluginClassLoader loader : this.loaderList) {
            Enumeration<URL> e = loader.getResources(name);
            while (e.hasMoreElements()) {
                urls.add(e.nextElement());
            }
        }
        return urls.elements();
    }

    @Override
    public Stream<URL> resources(String name) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (PluginClassLoader loader : this.loaderList) {
            urls.addAll(loader.resources(name).toList());
        }
        return urls.stream();
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        for (PluginClassLoader loader : this.loaderList) {
            InputStream is = loader.getResourceAsStream(name);
            if (is == null) continue;
            return is;
        }
        return null;
    }

    @Override
    public void setDefaultAssertionStatus(boolean enabled) {
        for (PluginClassLoader loader : this.loaderList) {
            loader.setDefaultAssertionStatus(enabled);
        }
    }

    @Override
    public void setPackageAssertionStatus(String packageName, boolean enabled) {
        for (PluginClassLoader loader : this.loaderList) {
            loader.setPackageAssertionStatus(packageName, enabled);
        }
    }

    @Override
    public void setClassAssertionStatus(String className, boolean enabled) {
        for (PluginClassLoader loader : this.loaderList) {
            loader.setClassAssertionStatus(className, enabled);
        }
    }

    @Override
    public void clearAssertionStatus() {
        for (PluginClassLoader loader : this.loaderList) {
            loader.clearAssertionStatus();
        }
    }

    @Override
    public String getName() {
        return "cn.srclink.service.plugin.MultiPluginClassLoaderImpl";
    }

    @Override
    public void reload() {
        for (PluginClassLoader loader : this.loaderList) {
            loader.reload();
        }
    }
}

