/*
 * Decompiled with CFR 0.152.
 */
package cn.srclink.service.plugin;

import cn.srclink.service.plugin.PluginClassLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarPluginClassLoaderImpl
extends PluginClassLoader {
    private static final Logger log = LoggerFactory.getLogger(JarPluginClassLoaderImpl.class);
    private final transient ClassLoader parent;
    private final File pluginDir;
    private transient ClassLoader delegate;

    public JarPluginClassLoaderImpl(File pluginDir) {
        this(JarPluginClassLoaderImpl.class.getClassLoader(), pluginDir);
    }

    public JarPluginClassLoaderImpl(ClassLoader parent, File pluginDir) {
        this.parent = parent;
        this.pluginDir = pluginDir;
        this.reload();
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.delegate.loadClass(name);
    }

    @Override
    public URL getResource(String name) {
        return this.delegate.getResource(name);
    }

    @Override
    public String getName() {
        return "cn.srclink.service.plugin.JarPluginClassLoaderImpl";
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return this.delegate.getResources(name);
    }

    @Override
    public Stream<URL> resources(String name) {
        return this.delegate.resources(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return this.delegate.getResourceAsStream(name);
    }

    @Override
    public void setDefaultAssertionStatus(boolean enabled) {
        this.delegate.setDefaultAssertionStatus(enabled);
    }

    @Override
    public void setPackageAssertionStatus(String packageName, boolean enabled) {
        this.delegate.setPackageAssertionStatus(packageName, enabled);
    }

    @Override
    public void setClassAssertionStatus(String className, boolean enabled) {
        this.delegate.setClassAssertionStatus(className, enabled);
    }

    @Override
    public void clearAssertionStatus() {
        this.delegate.clearAssertionStatus();
    }

    @Override
    public final void reload() {
        File[] plugins = this.pluginDir.listFiles();
        ArrayList urls = new ArrayList();
        if (plugins != null) {
            Arrays.stream(plugins).filter(plugin -> plugin.getName().endsWith(".jar")).forEach(plugin -> {
                try {
                    urls.add(plugin.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    log.error("Load plugin error: {}", (Object)e.getMessage());
                }
            });
        }
        this.delegate = new URLClassLoader(urls.toArray(new URL[0]), this.parent);
    }
}

