/*
 * Decompiled with CFR 0.152.
 */
package cn.srclink.service;

import cn.srclink.service.ServiceProvider;
import cn.srclink.service.plugin.JarPluginClassLoaderImpl;
import cn.srclink.service.plugin.PluginClassLoader;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CustomizedServiceLoader<S>
implements Iterable<S>,
Serializable {
    private static final List<ServiceProvider> providerList = new ArrayList<ServiceProvider>();
    private static final Logger log = LoggerFactory.getLogger(CustomizedServiceLoader.class);
    private static PluginClassLoader loader = new JarPluginClassLoaderImpl(new File("plugins"));
    private final ServiceLoader<S> serviceLoader;
    private final Class<S> serviceClass;
    private List<S> cachedServices;

    public CustomizedServiceLoader(ServiceLoader<S> serviceLoader, Class<S> serviceClass) {
        this.serviceLoader = serviceLoader;
        this.serviceClass = serviceClass;
    }

    public CustomizedServiceLoader(Class<S> serviceClass, PluginClassLoader pluginClassLoader) {
        this(ServiceLoader.load(serviceClass, pluginClassLoader), serviceClass);
    }

    public CustomizedServiceLoader(Class<S> serviceClass) {
        this(serviceClass, loader);
    }

    public static PluginClassLoader getLoader() {
        return loader;
    }

    public static void setLoader(PluginClassLoader loader) {
        CustomizedServiceLoader.loader = loader;
    }

    public static <S> CustomizedServiceLoader<S> load(Class<S> serviceClass) {
        return new CustomizedServiceLoader<S>(serviceClass);
    }

    public static <S> CustomizedServiceLoader<S> load(Class<S> serviceClass, PluginClassLoader loader) {
        return new CustomizedServiceLoader<S>(serviceClass, loader);
    }

    public static void addProvider(ServiceProvider serviceProvider) {
        if (providerList.contains(serviceProvider)) {
            return;
        }
        providerList.add(serviceProvider);
    }

    public static void removeProvider(ServiceProvider serviceProvider) {
        providerList.remove(serviceProvider);
    }

    public void reload() {
        loader.reload();
        this.serviceLoader.reload();
        this.cachedServices = null;
    }

    @Override
    @NotNull
    public Iterator<S> iterator() {
        if (this.cachedServices == null) {
            ArrayList<S> serviceList = new ArrayList<S>();
            ArrayList<String> serviceNameList = new ArrayList<String>();
            for (ServiceProvider serviceProvider : providerList) {
                for (S service : serviceProvider.load(this.serviceClass)) {
                    if (serviceNameList.contains(service.getClass().getName())) continue;
                    serviceList.add(service);
                    serviceNameList.add(service.getClass().getName());
                    log.debug("Loading {}@{} by provider {}", new Object[]{service.getClass().getName(), Integer.toHexString(System.identityHashCode(service)), serviceProvider.getClass().getName()});
                }
            }
            for (ServiceProvider service : this.serviceLoader) {
                if (serviceNameList.contains(service.getClass().getName())) continue;
                serviceList.add(service);
                serviceNameList.add(service.getClass().getName());
            }
            this.cachedServices = serviceList;
        }
        Iterator<S> result = this.cachedServices.iterator();
        return result;
    }
}

