/*
 * Decompiled with CFR 0.152.
 */
package cn.springlet.redis.redisson;

import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RedissonService {
    private static final Logger log = LoggerFactory.getLogger(RedissonService.class);
    @Autowired
    private RedissonClient redissonClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T lockTemplate(String name, Supplier<T> supplier) {
        RLock lock = this.redissonClient.getLock(name);
        try {
            lock.lock();
            log.debug("lockTemplate->\u9501 {} \u83b7\u53d6", (Object)name);
            T t = supplier.get();
            return t;
        }
        finally {
            this.unlock("lockTemplate", lock, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockTemplate(String name, Runnable runnable) {
        RLock lock = this.redissonClient.getLock(name);
        try {
            lock.lock();
            log.debug("lockTemplate->\u9501 {} \u83b7\u53d6", (Object)name);
            runnable.run();
        }
        finally {
            this.unlock("lockTemplate", lock, name);
        }
    }

    public <T> T lockExpireTemplate(String name, Supplier<T> supplier) {
        return this.lockExpireTemplate(name, 5000L, supplier);
    }

    public void lockExpireTemplate(String name, Runnable runnable) {
        this.lockExpireTemplate(name, 5000L, runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T lockExpireTemplate(String name, long expire, Supplier<T> supplier) {
        RLock lock = this.redissonClient.getLock(name);
        try {
            lock.lock(expire, TimeUnit.MILLISECONDS);
            log.debug("lockExpireTemplate->\u9501 {} \u83b7\u53d6", (Object)name);
            T t = supplier.get();
            return t;
        }
        finally {
            this.unlock("lockExpireTemplate", lock, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockExpireTemplate(String name, long expire, Runnable runnable) {
        RLock lock = this.redissonClient.getLock(name);
        try {
            lock.lock(expire, TimeUnit.MILLISECONDS);
            log.debug("lockExpireTemplate->\u9501 {} \u83b7\u53d6", (Object)name);
            runnable.run();
        }
        finally {
            this.unlock("lockExpireTemplate", lock, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T tryLockExpireTemplate(String name, long wait, long expire, Supplier<T> supplier, Supplier<T> waitTimeoutSupplier) throws InterruptedException {
        RLock lock = this.redissonClient.getLock(name);
        boolean isGet = lock.tryLock(wait, expire, TimeUnit.MILLISECONDS);
        if (!isGet) {
            log.debug("tryLockExpireTemplate->\u9501 {} \u83b7\u53d6\u8d85\u65f6,\u6267\u884c\u8d85\u65f6\u903b\u8f91", (Object)name);
            return waitTimeoutSupplier.get();
        }
        try {
            log.debug("tryLockExpireTemplate->\u9501 {} \u83b7\u53d6", (Object)name);
            T t = supplier.get();
            return t;
        }
        finally {
            this.unlock("tryLockExpireTemplate", lock, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryLockExpireTemplate(String name, long wait, long expire, Runnable runnable, Runnable waitTimeoutRunnable) throws InterruptedException {
        RLock lock = this.redissonClient.getLock(name);
        boolean isGet = lock.tryLock(wait, expire, TimeUnit.MILLISECONDS);
        if (!isGet) {
            log.debug("tryLockExpireTemplate->\u9501 {} \u83b7\u53d6\u8d85\u65f6,\u6267\u884c\u8d85\u65f6\u903b\u8f91", (Object)name);
            waitTimeoutRunnable.run();
        } else {
            try {
                log.debug("tryLockExpireTemplate->\u9501 {} \u83b7\u53d6", (Object)name);
                runnable.run();
            }
            finally {
                this.unlock("tryLockExpireTemplate", lock, name);
            }
        }
    }

    private void unlock(String method, RLock lock, String name) {
        try {
            lock.unlock();
            log.debug("{}->\u9501 {} \u91ca\u653e", (Object)method, (Object)name);
        }
        catch (IllegalMonitorStateException e) {
            log.error("{}->\u9501 [{}] \u5df2\u7ecf\u88ab\u91ca\u653e,\u65e0\u9700\u518d\u6b21\u91ca\u653e,\u4e1a\u52a1\u5904\u7406\u8d85\u65f6,\u56de\u6eda\u4e8b\u52a1", (Object)method, (Object)name);
            throw new RuntimeException("\u4e1a\u52a1\u5904\u7406\u8d85\u65f6");
        }
    }
}

