/*
 * Decompiled with CFR 0.152.
 */
package cn.springlet.redis.config;

import cn.springlet.redis.config.RedisCacheProperties;
import com.alibaba.fastjson.support.spring.GenericFastJsonRedisSerializer;
import java.time.Duration;
import java.util.Collections;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.CachingConfigurerSupport;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Configuration
@EnableCaching
public class SpringletRedisConfig
extends CachingConfigurerSupport {
    @Bean(value={"redisNoNewScript"})
    public DefaultRedisScript<Long> redisNoNewScript() {
        DefaultRedisScript redisScript = new DefaultRedisScript();
        redisScript.setScriptText("if redis.call('get', KEYS[1]) then \n    return 1 \nelse \n    redis.call('set', KEYS[1], ARGV[1]) \n    redis.call('pexpire', KEYS[1], ARGV[2]) \n    return 0 \nend");
        redisScript.setResultType(Long.class);
        return redisScript;
    }

    @Bean(value={"redisRateLimiterScript"})
    public DefaultRedisScript<Long> redisRateLimiterScript() {
        DefaultRedisScript redisScript = new DefaultRedisScript();
        redisScript.setScriptText("for i=1,#KEYS do\n local current = redis.call('get', KEYS[i])\n if current and tonumber(current) >= tonumber(ARGV[i*2-1]) then\n  return i-1\n end\nend\n\nfor i=1,#KEYS do\n    local current = redis.call('incr', KEYS[i])\n    if tonumber(current) == 1 then\n        redis.call('pexpire', KEYS[i], ARGV[i*2])\n    end\nend");
        redisScript.setResultType(Long.class);
        return redisScript;
    }

    @Bean
    public RedisTemplate<Object, Object> redisTemplate(RedisConnectionFactory connectionFactory) {
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory(connectionFactory);
        GenericFastJsonRedisSerializer serializer = new GenericFastJsonRedisSerializer();
        StringRedisSerializer keySerializer = new StringRedisSerializer();
        template.setKeySerializer((RedisSerializer)keySerializer);
        template.setValueSerializer((RedisSerializer)serializer);
        template.setHashKeySerializer((RedisSerializer)keySerializer);
        template.setHashValueSerializer((RedisSerializer)serializer);
        template.afterPropertiesSet();
        return template;
    }

    @Bean
    public CacheManager cacheManager(RedisConnectionFactory factory, RedisCacheProperties redisCacheProperties) {
        RedisCacheConfiguration config = RedisCacheConfiguration.defaultCacheConfig().computePrefixWith(name -> name + "").entryTtl(Duration.ofSeconds(redisCacheProperties.getTimeout()));
        RedisCacheConfiguration redisCacheConfiguration = config.serializeKeysWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new StringRedisSerializer())).serializeValuesWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new GenericFastJsonRedisSerializer()));
        RedisCacheManager cacheManager = RedisCacheManager.builder((RedisCacheWriter)RedisCacheWriter.lockingRedisCacheWriter((RedisConnectionFactory)factory)).cacheDefaults(redisCacheConfiguration).withInitialCacheConfigurations(Collections.singletonMap("test_cache", RedisCacheConfiguration.defaultCacheConfig().entryTtl(Duration.ofMinutes(5L)).disableCachingNullValues())).transactionAware().build();
        return cacheManager;
    }
}

