/*
 * Decompiled with CFR 0.152.
 */
package cn.springlet.redis.aspect;

import cn.springlet.core.auto_config.SPELParserUtils;
import cn.springlet.core.exception.web_return.RateLimiterException;
import cn.springlet.core.exception.web_return.ReturnMsgException;
import cn.springlet.core.util.StrUtil;
import cn.springlet.redis.annotation.RedisRateLimiter;
import cn.springlet.redis.annotation.RedisRateLimiters;
import cn.springlet.redis.bean.RedisRateLimiterBean;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Order(value=-1)
public class RedisRateLimiterAspect {
    private static final Logger log = LoggerFactory.getLogger(RedisRateLimiterAspect.class);
    @Autowired
    private RedisTemplate<Object, Object> redisTemplate;
    @Autowired
    @Qualifier(value="redisRateLimiterScript")
    private RedisScript<Long> limitScript;

    @Pointcut(value="@annotation(cn.springlet.redis.annotation.RedisRateLimiter) || @annotation(cn.springlet.redis.annotation.RedisRateLimiters)")
    public void pointcut() {
    }

    @Before(value="pointcut()")
    public void doBefore(JoinPoint point) {
        MethodSignature sign = (MethodSignature)point.getSignature();
        Method method = sign.getMethod();
        RedisRateLimiter redisRateLimiter = (RedisRateLimiter)AnnotationUtils.findAnnotation((Method)method, RedisRateLimiter.class);
        RedisRateLimiters redisRateLimiters = (RedisRateLimiters)AnnotationUtils.findAnnotation((Method)method, RedisRateLimiters.class);
        ArrayList<RedisRateLimiterBean> beanList = new ArrayList<RedisRateLimiterBean>();
        if (redisRateLimiter != null) {
            beanList.add(this.initBean(redisRateLimiter));
        }
        if (redisRateLimiters != null) {
            for (RedisRateLimiter rateLimiter : redisRateLimiters.value()) {
                beanList.add(this.initBean(rateLimiter));
            }
        }
        this.handleRateLimiter(beanList, point);
    }

    private void handleRateLimiter(List<RedisRateLimiterBean> beanList, JoinPoint point) {
        RedisRateLimiterBean redisRateLimiterBean;
        beanList = beanList.stream().sorted(Comparator.comparing(RedisRateLimiterBean::getMillisecondsTime).reversed()).collect(Collectors.toList());
        int size = beanList.size();
        ArrayList<String> keys = new ArrayList<String>();
        Object[] args = new Object[size * 2];
        for (int i = 0; i < size; ++i) {
            redisRateLimiterBean = beanList.get(i);
            keys.add(this.getKey(point, redisRateLimiterBean.getKey()));
            int pageIndex = i * 2;
            args[pageIndex] = redisRateLimiterBean.getCount();
            args[pageIndex + 1] = redisRateLimiterBean.getMillisecondsTime();
        }
        try {
            Long index = (Long)this.redisTemplate.execute(this.limitScript, keys, args);
            if (index == null) {
                return;
            }
            redisRateLimiterBean = beanList.get(index.intValue());
            log.info("\u89e6\u53d1\u9650\u6d41:\u9650\u6d41key:{},\u9650\u6d41\u914d\u7f6e:\u6b21\u6570{},\u65f6\u95f4:{},\u65f6\u95f4\u5355\u4f4d:{}", new Object[]{this.getKey(point, redisRateLimiterBean.getKey()), redisRateLimiterBean.getCount(), redisRateLimiterBean.getTime(), redisRateLimiterBean.getUnit()});
            throw new RateLimiterException(redisRateLimiterBean.getErrMsg());
        }
        catch (RateLimiterException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("\u670d\u52a1\u5668\u9650\u6d41\u5f02\u5e38", (Throwable)e);
            throw new ReturnMsgException("\u670d\u52a1\u5668\u9650\u6d41\u5f02\u5e38\uff0c\u8bf7\u7a0d\u5019\u518d\u8bd5");
        }
    }

    private String getKey(JoinPoint joinPoint, String annotationKey) {
        String parseValue;
        String className = joinPoint.getTarget().getClass().getName();
        String methodName = joinPoint.getSignature().getName();
        String key = null;
        key = StrUtil.isNotBlank((CharSequence)annotationKey) ? (StrUtil.isBlank((CharSequence)(parseValue = (String)SPELParserUtils.parse((Method)((MethodSignature)joinPoint.getSignature()).getMethod(), (Object[])joinPoint.getArgs(), (String)annotationKey, String.class))) ? StrUtil.format((CharSequence)"{}#{}", (Object[])new Object[]{className, methodName}) : StrUtil.format((CharSequence)"{}#{}#{}", (Object[])new Object[]{className, methodName, parseValue})) : StrUtil.format((CharSequence)"{}#{}", (Object[])new Object[]{className, methodName});
        return "springlet:RATE_LIMITER_KEY:" + key;
    }

    private RedisRateLimiterBean initBean(RedisRateLimiter redisRateLimiter) {
        RedisRateLimiterBean redisRateLimiterBean = new RedisRateLimiterBean();
        redisRateLimiterBean.setTime(redisRateLimiter.time());
        redisRateLimiterBean.setUnit(redisRateLimiter.unit());
        redisRateLimiterBean.setKey(redisRateLimiter.key());
        redisRateLimiterBean.setCount(redisRateLimiter.count());
        redisRateLimiterBean.setErrMsg(redisRateLimiter.errMsg());
        redisRateLimiterBean.setMillisecondsTime(Long.valueOf(redisRateLimiter.unit().toMillis(redisRateLimiter.time())).intValue());
        return redisRateLimiterBean;
    }
}

