/*
 * Decompiled with CFR 0.152.
 */
package cn.springlet.redis.aspect;

import cn.hutool.crypto.SecureUtil;
import cn.springlet.core.auto_config.SPELParserUtils;
import cn.springlet.core.enums.HeaderConstantsEnum;
import cn.springlet.core.exception.web_return.RepeatSubmitException;
import cn.springlet.core.util.ServletUtil;
import cn.springlet.core.util.StrUtil;
import cn.springlet.redis.annotation.NoRepeatSubmit;
import cn.springlet.redis.util.RedisUtil;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Order(value=-2)
public class NoRepeatSubmitAspect {
    private final RedisUtil redisUtil;

    @Pointcut(value="@annotation(cn.springlet.redis.annotation.NoRepeatSubmit)")
    public void pointcut() {
    }

    @Around(value="pointcut() && @annotation(noRepeatSubmit)")
    public Object handler(ProceedingJoinPoint joinPoint, NoRepeatSubmit noRepeatSubmit) throws Throwable {
        String annotationKey = noRepeatSubmit.key();
        String key = this.getKey(joinPoint, annotationKey);
        if (this.redisUtil.hasKey(key)) {
            String errMsg = noRepeatSubmit.errMsg();
            if (StrUtil.isBlank((CharSequence)errMsg)) {
                throw new RepeatSubmitException("\u8bbf\u95ee\u901f\u5ea6\u8fc7\u5feb,\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
            }
            throw new RepeatSubmitException(errMsg);
        }
        this.redisUtil.set(key, 1, noRepeatSubmit.time(), noRepeatSubmit.unit());
        return joinPoint.proceed();
    }

    private String getKey(ProceedingJoinPoint joinPoint, String annotationKey) {
        String parseValue;
        String token = ServletUtil.getRequest().getHeader(HeaderConstantsEnum.Authorization.name());
        String className = joinPoint.getTarget().getClass().getName();
        String methodName = joinPoint.getSignature().getName();
        String key = null;
        key = StrUtil.isNotBlank((CharSequence)annotationKey) ? (StrUtil.isBlank((CharSequence)(parseValue = (String)SPELParserUtils.parse((Method)((MethodSignature)joinPoint.getSignature()).getMethod(), (Object[])joinPoint.getArgs(), (String)annotationKey, String.class))) ? StrUtil.format((CharSequence)"{}#{}#{}", (Object[])new Object[]{token, className, methodName}) : StrUtil.format((CharSequence)"{}#{}#{}#{}", (Object[])new Object[]{token, className, methodName, parseValue})) : StrUtil.format((CharSequence)"{}#{}#{}", (Object[])new Object[]{token, className, methodName});
        return "springlet:NO_REPEAT_SUBMIT_KEY:" + SecureUtil.md5((String)key);
    }

    public NoRepeatSubmitAspect(RedisUtil redisUtil) {
        this.redisUtil = redisUtil;
    }
}

