/*
 * Decompiled with CFR 0.152.
 */
package cn.springlet.redis.aspect;

import cn.springlet.core.exception.web_return.DisableReplayException;
import cn.springlet.core.exception.web_return.ParameterVerificationException;
import cn.springlet.core.exception.web_return.ReturnMsgException;
import cn.springlet.core.util.ServletUtil;
import cn.springlet.core.util.StrUtil;
import cn.springlet.redis.annotation.DisableReplay;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Order(value=-3)
public class DisableReplayAspect {
    private static final Logger log = LoggerFactory.getLogger(DisableReplayAspect.class);
    @Autowired
    private RedisTemplate<Object, Object> redisTemplate;
    @Autowired
    @Qualifier(value="redisNoNewScript")
    private RedisScript<Long> noNewScript;

    @Pointcut(value="@annotation(cn.springlet.redis.annotation.DisableReplay)")
    public void pointcut() {
    }

    @Before(value="pointcut() && @annotation(disableReplay)")
    public void handler(JoinPoint joinPoint, DisableReplay disableReplay) {
        int time = disableReplay.time();
        TimeUnit unit = disableReplay.unit();
        String timeStampFiledName = disableReplay.timeStampFiledName();
        String nonceFiledName = disableReplay.nonceFiledName();
        HttpServletRequest request = ServletUtil.getRequest();
        if (request == null) {
            log.error("DisableReplayAspect:\u8bf7\u6c42\u4e0a\u4e0b\u6587\u4e0d\u5b58\u5728");
            throw new ReturnMsgException("\u8bf7\u6c42\u4e0a\u4e0b\u6587\u4e0d\u5b58\u5728");
        }
        String timeStamp = request.getHeader(timeStampFiledName);
        String nonce = request.getHeader(nonceFiledName);
        if (StrUtil.isBlank((CharSequence)timeStamp)) {
            timeStamp = request.getParameter(timeStampFiledName);
        }
        if (StrUtil.isBlank((CharSequence)nonce)) {
            nonce = request.getParameter(nonceFiledName);
        }
        if (StrUtil.isBlank((CharSequence)timeStamp)) {
            throw new ParameterVerificationException("\u65f6\u95f4\u6233\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isBlank((CharSequence)nonce)) {
            throw new ParameterVerificationException("\u968f\u673a\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long longTimeStamp = null;
        try {
            longTimeStamp = Long.parseLong(timeStamp);
        }
        catch (NumberFormatException e) {
            throw new ParameterVerificationException("\u65f6\u95f4\u6233\u683c\u5f0f\u9519\u8bef");
        }
        long nowTimeStamp = System.currentTimeMillis();
        long millisTime = unit.toMillis(time);
        if (longTimeStamp > nowTimeStamp) {
            throw new ReturnMsgException("\u65f6\u95f4\u6233\u5f02\u5e38");
        }
        if (nowTimeStamp - longTimeStamp >= millisTime) {
            throw new ReturnMsgException("\u8bf7\u6c42\u5df2\u8fc7\u671f");
        }
        ArrayList<String> keys = new ArrayList<String>();
        keys.add("springlet:DISABLE_REPLAY_KEY:" + nonce);
        try {
            Long result = (Long)this.redisTemplate.execute(this.noNewScript, keys, new Object[]{1, (int)millisTime});
            if (result == null || result != 0L) {
                throw new DisableReplayException("\u8bf7\u6c42\u91cd\u653e");
            }
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u91cd\u653e\u9650\u5236\u5f02\u5e38", (Throwable)e);
            throw new ReturnMsgException("\u670d\u52a1\u5668\u5f02\u5e38\uff0c\u8bf7\u7a0d\u5019\u518d\u8bd5");
        }
    }
}

