package cn.springlet.redis.bean;

import lombok.Getter;
import lombok.Setter;

import java.util.concurrent.TimeUnit;

/**
 * @author springlet
 * @time 2022/8/5
 */
@Getter
@Setter
public class RedisRateLimiterBean {

    /**
     * 限流时间
     * 默认 1
     *
     * @return
     */
    private Integer time;

    /**
     * 限流时间单位
     * 默认 秒
     *
     * @return
     */
    private TimeUnit unit;

    /**
     * 限流key, 支持SPEL 表达式
     *
     * @return
     */
    private String key;


    /**
     * 限流次数
     * 默认 1
     */
    private Integer count;

    /**
     * 错误返回消息
     *
     * @return
     */
    private String errMsg;

    /**
     * 毫秒
     */
    private Integer millisecondsTime;
}
