package cn.springlet.redis.annotation;


import java.lang.annotation.*;
import java.util.concurrent.TimeUnit;

/**
 * 限流
 *
 * @author springlet
 * @time 2020/11/05
 */
@Target({ElementType.METHOD, ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface RedisRateLimiter {

    /**
     * 限流时间
     * 默认 1
     *
     * @return
     */
    int time() default 1;

    /**
     * 限流时间单位
     * 默认 秒
     *
     * @return
     */
    TimeUnit unit() default TimeUnit.MILLISECONDS;

    /**
     * 限流key, 支持SPEL 表达式
     *
     * @return
     */
    String key() default "";


    /**
     * 限流次数
     * 默认 1
     */
    int count() default 1;

    /**
     * 错误返回消息
     *
     * @return
     */
    String errMsg() default "访问过于频繁，请稍候再试！";
}
