package cn.springlet.redis.annotation;


import java.lang.annotation.*;
import java.util.concurrent.TimeUnit;

/**
 * 禁止 请求重放
 *
 * @author springlet
 * @time 2020/9/24
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD, ElementType.TYPE})
@Documented
public @interface DisableReplay {

    /**
     * 请求有效时间
     * 默认 300 秒
     */
    int time() default 300;

    /**
     * 时间单位
     * 默认 秒
     *
     * @return
     */
    TimeUnit unit() default TimeUnit.SECONDS;


    /**
     * 时间戳字段名称
     * 默认 drTimeStamp
     *
     * @return
     */
    String timeStampFiledName() default "drTimeStamp";

    /**
     * 随机字符串字段名称
     * 默认 drNonce
     *
     * @return
     */
    String nonceFiledName() default "drNonce";
}