/*
 * Decompiled with CFR 0.152.
 */
package cn.springlet.log.filter;

import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import cn.springlet.core.enums.HeaderConstantsEnum;
import cn.springlet.core.util.ServletUtil;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.slf4j.MDC;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;

@Configuration
public class DefaultLogNoFilter
implements Filter,
Ordered {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        String logNo = ServletUtil.getRequest().getHeader(HeaderConstantsEnum.LOG_NO.name());
        if (StrUtil.isBlank((CharSequence)logNo)) {
            logNo = IdUtil.getSnowflakeNextIdStr();
        }
        MDC.put((String)HeaderConstantsEnum.LOG_NO.name(), (String)logNo);
        try {
            filterChain.doFilter(servletRequest, servletResponse);
        }
        finally {
            MDC.clear();
        }
    }

    public int getOrder() {
        return -1;
    }
}

