/*
 * Decompiled with CFR 0.152.
 */
package cn.springlet.log.bean;

import cn.hutool.core.util.StrUtil;
import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Objects;

public class LogBean
implements Serializable {
    private static final long serialVersionUID = -8127325270756589149L;
    private String title;
    private String className;
    private String methodName;
    private String parameter;
    private String returnObject;
    private LocalDateTime startTime;
    private LocalDateTime endTime;
    private boolean returnTag = false;

    public LogBean() {
    }

    public LogBean(LogBean bean) {
        this.setTitle(bean.getTitle());
        this.setClassName(bean.getClassName());
        this.setMethodName(bean.getMethodName());
        this.setParameter(bean.getParameter());
        this.setReturnObject(bean.getReturnObject());
        this.setStartTime(bean.getStartTime());
        this.setEndTime(bean.getEndTime());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.title);
        stringBuilder.append("->");
        this.assemblyLog(stringBuilder);
        return stringBuilder.toString();
    }

    protected void otherLog(StringBuilder stringBuilder) {
    }

    public void closeSomeLog() {
        this.returnTag = true;
    }

    protected void assemblyLog(StringBuilder stringBuilder) {
        if (!this.returnTag && StrUtil.isNotBlank((CharSequence)this.parameter)) {
            stringBuilder.append("\u53c2\u6570:");
            stringBuilder.append(this.parameter);
        }
        if (this.returnTag && StrUtil.isNotBlank((CharSequence)this.returnObject)) {
            stringBuilder.append("\u8fd4\u56de\u503c:");
            stringBuilder.append(this.returnObject);
        }
        if (!this.returnTag) {
            stringBuilder.append(", ");
            stringBuilder.append("\u65b9\u6cd5:");
            stringBuilder.append(this.className);
            stringBuilder.append("#");
            stringBuilder.append(this.methodName);
        }
        this.otherLog(stringBuilder);
        if (Objects.nonNull(this.startTime) && Objects.nonNull(this.endTime)) {
            stringBuilder.append(", ");
            stringBuilder.append("\u6267\u884c\u65f6\u95f4:");
            stringBuilder.append(Duration.between(this.startTime, this.endTime).toMillis());
            stringBuilder.append("\u6beb\u79d2");
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void setParameter(String parameter) {
        this.parameter = parameter;
    }

    public void setReturnObject(String returnObject) {
        this.returnObject = returnObject;
    }

    public void setStartTime(LocalDateTime startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(LocalDateTime endTime) {
        this.endTime = endTime;
    }

    public void setReturnTag(boolean returnTag) {
        this.returnTag = returnTag;
    }

    public String getTitle() {
        return this.title;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getParameter() {
        return this.parameter;
    }

    public String getReturnObject() {
        return this.returnObject;
    }

    public LocalDateTime getStartTime() {
        return this.startTime;
    }

    public LocalDateTime getEndTime() {
        return this.endTime;
    }

    public boolean isReturnTag() {
        return this.returnTag;
    }
}

