/*
 * Decompiled with CFR 0.152.
 */
package cn.springlet.log.bean;

import cn.springlet.core.util.ServletUtil;
import cn.springlet.log.bean.LogBean;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class HttpLogBean
extends LogBean {
    private static final long serialVersionUID = -5696019829680542363L;
    private String requestURI;
    private String requestMethod;
    private String remoteAddr;
    private boolean isHttpRequest = true;

    public HttpLogBean() {
        this.init();
    }

    public HttpLogBean(LogBean bean) {
        super(bean);
        this.init();
    }

    private void init() {
        HttpServletRequest request = ServletUtil.getRequest();
        if (request != null) {
            this.setRemoteAddr(ServletUtil.getClientIP((HttpServletRequest)request, (String[])new String[0]));
            this.setRequestMethod(request.getMethod());
            this.setRequestURI(request.getRequestURI());
        }
        if (StringUtils.isBlank((CharSequence)this.getTitle()) || "\u670d\u52a1".equals(this.getTitle())) {
            this.setTitle("http\u8bf7\u6c42");
        }
    }

    @Override
    protected void otherLog(StringBuilder stringBuilder) {
        if (this.isHttpRequest) {
            stringBuilder.append(", ");
            stringBuilder.append("\u8bf7\u6c42\u63a5\u53e3:");
            stringBuilder.append(this.requestURI);
            stringBuilder.append(", ");
            stringBuilder.append("\u8bf7\u6c42\u65b9\u5f0f:");
            stringBuilder.append(this.requestMethod);
            stringBuilder.append(", ");
            stringBuilder.append("\u6765\u6e90IP:");
            stringBuilder.append(this.remoteAddr);
        }
    }

    @Override
    public void closeSomeLog() {
        super.closeSomeLog();
        this.isHttpRequest = false;
    }

    public void setRequestURI(String requestURI) {
        this.requestURI = requestURI;
    }

    public void setRequestMethod(String requestMethod) {
        this.requestMethod = requestMethod;
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public void setHttpRequest(boolean isHttpRequest) {
        this.isHttpRequest = isHttpRequest;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public boolean isHttpRequest() {
        return this.isHttpRequest;
    }
}

