/*
 * Decompiled with CFR 0.152.
 */
package cn.springlet.log.aspect;

import cn.springlet.core.auto_config.SPELParserUtils;
import cn.springlet.core.util.StrUtil;
import cn.springlet.log.annotation.AspectLog;
import cn.springlet.log.aspect.BasePrintLogAspect;
import cn.springlet.log.bean.HttpLogBean;
import cn.springlet.log.bean.LogBean;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RestController;

@Aspect
@Component
public class PrintMethodAnnotationLogAspect
extends BasePrintLogAspect {
    @Pointcut(value="@annotation(cn.springlet.log.annotation.AspectLog)")
    public void logMethod() {
    }

    @Around(value="logMethod() && @annotation(aspectLog)")
    public Object aroundMethod(ProceedingJoinPoint joinPoint, AspectLog aspectLog) throws Throwable {
        String title = StringUtils.isBlank((CharSequence)aspectLog.title()) ? aspectLog.value() : aspectLog.title();
        String spel = aspectLog.spel();
        if (StrUtil.isNotBlank((CharSequence)spel)) {
            title = (String)SPELParserUtils.parse((Method)((MethodSignature)joinPoint.getSignature()).getMethod(), (Object[])joinPoint.getArgs(), (String)spel, String.class);
        }
        return super.logNote(joinPoint, aspectLog.level(), title);
    }

    @Override
    protected LogBean logHandle(ProceedingJoinPoint joinPoint, LogBean logBean) {
        MethodSignature sign = (MethodSignature)joinPoint.getSignature();
        Method method = sign.getMethod();
        AspectLog aspectLog = method.getAnnotation(AspectLog.class);
        if (aspectLog.isHttpRequest() || joinPoint.getTarget().getClass().isAnnotationPresent(Controller.class) || joinPoint.getTarget().getClass().isAnnotationPresent(RestController.class)) {
            return new HttpLogBean(logBean);
        }
        return logBean;
    }
}

