/*
 * Decompiled with CFR 0.152.
 */
package cn.springlet.log.aspect;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.springlet.core.bean.page.PageInfo;
import cn.springlet.core.bean.web.HttpResult;
import cn.springlet.log.bean.LogBean;
import com.alibaba.fastjson.JSON;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class BasePrintLogAspect {
    private static final Logger log = LoggerFactory.getLogger(BasePrintLogAspect.class);
    public static final String SERVICE_TITLE = "\u670d\u52a1";
    public static final String HTTP_TITLE = "http\u8bf7\u6c42";

    protected Object logNote(ProceedingJoinPoint joinPoint, Level level, String title) throws Throwable {
        if (!this.checkLogLevel(level)) {
            return joinPoint.proceed();
        }
        LogBean logBean = new LogBean();
        logBean.setTitle(title);
        if (StrUtil.isBlank((CharSequence)title)) {
            logBean.setTitle(SERVICE_TITLE);
        }
        logBean.setClassName(joinPoint.getTarget().getClass().getName());
        logBean.setMethodName(joinPoint.getSignature().getName());
        try {
            logBean.setParameter(JSON.toJSONString((Object)joinPoint.getArgs()));
        }
        catch (Exception e) {
            log.info("BasePrintLogAspect:logNote:\u5207\u9762\u65e5\u5fd7\u5f02\u5e38->JSON\u5e8f\u5217\u5316\u53c2\u6570\u5f02\u5e38:{}", (Object)e.getMessage());
        }
        logBean.setStartTime(LocalDateTime.now());
        LogBean otherLogBean = this.logHandle(joinPoint, logBean);
        this.printParams(otherLogBean, level);
        Object proceed = null;
        try {
            proceed = joinPoint.proceed();
        }
        catch (Exception e) {
            otherLogBean.setTitle(otherLogBean.getTitle().substring(0, otherLogBean.getTitle().length() - 3) + "-\u5f02\u5e38\u4fe1\u606f\u54cd\u5e94");
            otherLogBean.setEndTime(LocalDateTime.now());
            otherLogBean.setReturnObject(e.getMessage());
            this.printReturn(otherLogBean, level);
            throw e;
        }
        otherLogBean.setTitle(otherLogBean.getTitle().substring(0, otherLogBean.getTitle().length() - 3));
        otherLogBean.setEndTime(LocalDateTime.now());
        try {
            this.setReturnObject(proceed, otherLogBean);
        }
        catch (Exception e) {
            log.info("BasePrintLogAspect:logNote:\u5207\u9762\u65e5\u5fd7\u5f02\u5e38->JSON\u5e8f\u5217\u5316\u8fd4\u56de\u503c\u5f02\u5e38:{}", (Object)e.getMessage());
        }
        this.printReturn(otherLogBean, level);
        return proceed;
    }

    private void setReturnObject(Object proceed, LogBean otherLogBean) {
        if (proceed instanceof HttpResult) {
            HttpResult httpResult = (HttpResult)proceed;
            Object data = httpResult.getData();
            if (data instanceof Collection) {
                Collection collection = (Collection)data;
                if (CollUtil.isNotEmpty((Collection)collection)) {
                    otherLogBean.setReturnObject("\u8fd4\u56de\u4fe1\u606f\u4e3a\u96c6\u5408\uff0c\u96c6\u5408\u5927\u5c0f\uff1a" + collection.size());
                } else {
                    otherLogBean.setReturnObject("\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a\u96c6\u5408");
                }
                return;
            }
            if (data instanceof PageInfo) {
                List collection = ((PageInfo)data).getRecords();
                if (CollUtil.isNotEmpty((Collection)collection)) {
                    otherLogBean.setReturnObject("\u8fd4\u56de\u4fe1\u606f\u4e3a\u96c6\u5408\uff0c\u96c6\u5408\u5927\u5c0f\uff1a" + collection.size());
                } else {
                    otherLogBean.setReturnObject("\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a\u96c6\u5408");
                }
                return;
            }
        }
        otherLogBean.setReturnObject(JSON.toJSONString((Object)proceed));
    }

    protected LogBean logHandle(ProceedingJoinPoint joinPoint, LogBean logBean) {
        return logBean;
    }

    protected void printParams(LogBean logBean, Level level) {
        logBean.setTitle(logBean.getTitle() + ":\u8c03\u7528");
        this.printLog(logBean, level);
    }

    protected void printReturn(LogBean logBean, Level level) {
        logBean.setTitle(logBean.getTitle() + ":\u8fd4\u56de");
        logBean.closeSomeLog();
        this.printLog(logBean, level);
    }

    protected void printLog(LogBean logBean, Level level) {
        switch (level) {
            case TRACE: {
                log.trace(logBean.toString());
                break;
            }
            case DEBUG: {
                log.debug(logBean.toString());
                break;
            }
            case INFO: {
                log.info(logBean.toString());
                break;
            }
            case WARN: {
                log.warn(logBean.toString());
                break;
            }
            case ERROR: {
                log.error(logBean.toString());
                break;
            }
        }
    }

    private boolean checkLogLevel(Level level) {
        switch (level) {
            case TRACE: {
                if (!log.isTraceEnabled()) break;
                return true;
            }
            case DEBUG: {
                if (!log.isDebugEnabled()) break;
                return true;
            }
            case INFO: {
                if (!log.isInfoEnabled()) break;
                return true;
            }
            case WARN: {
                if (!log.isWarnEnabled()) break;
                return true;
            }
            case ERROR: {
                if (!log.isErrorEnabled()) break;
                return true;
            }
        }
        return false;
    }
}

