/*
 * Decompiled with CFR 0.152.
 */
package cn.springlet.log.aspect;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.exceptions.ExceptionUtil;
import cn.springlet.core.util.IpUtil;
import cn.springlet.core.util.ServletUtil;
import cn.springlet.log.annotation.OptLog;
import cn.springlet.log.bean.OptLogBean;
import cn.springlet.log.bean.OptUserBean;
import com.alibaba.fastjson.JSON;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseOperationLogAspect {
    private static final Logger log = LoggerFactory.getLogger(BaseOperationLogAspect.class);

    @Pointcut(value="@annotation(cn.springlet.log.annotation.OptLog)")
    public void logPointCut() {
    }

    @Around(value="logPointCut()&& @annotation(optLog)")
    public Object around(ProceedingJoinPoint point, OptLog optLog) throws Throwable {
        TimeInterval timeInterval = DateUtil.timer();
        OptLogBean optLogBean = new OptLogBean();
        HttpServletRequest request = ServletUtil.getRequest();
        OptUserBean optInfo = this.getOptUserBean();
        optLogBean.setOptId(optInfo.getOptId());
        optLogBean.setOptAccount(optInfo.getOptAccount());
        optLogBean.setOptName(optInfo.getOptName());
        optLogBean.setOptIp(IpUtil.getClientIp());
        optLogBean.setRequestUrl(request.getRequestURI());
        optLogBean.setRequestMethod(request.getMethod());
        Object[] args = point.getArgs();
        try {
            optLogBean.setRequestParams(JSON.toJSONString((Object)args));
        }
        catch (Exception e) {
            optLogBean.setRequestParams("error:" + ExceptionUtil.stacktraceToString((Throwable)e, (int)350));
        }
        optLogBean.setRemoteAddr(IpUtil.getHostIp());
        optLogBean.setRequestClass(point.getTarget().getClass().getName() + "#" + point.getSignature().getName());
        optLogBean.setOptDesc(optLog.desc());
        optLogBean.setOptType(optLog.type().name());
        optLogBean.setGmtCreate(new Date());
        Object result = null;
        try {
            result = point.proceed();
        }
        catch (Exception e) {
            optLogBean.setResponseParams("error:" + ExceptionUtil.stacktraceToString((Throwable)e, (int)350));
            optLogBean.setExecTime(timeInterval.interval());
            this.insert(optLogBean);
            throw e;
        }
        try {
            optLogBean.setResponseParams(JSON.toJSONString((Object)result));
        }
        catch (Exception e) {
            optLogBean.setResponseParams("error:" + ExceptionUtil.stacktraceToString((Throwable)e, (int)350));
        }
        optLogBean.setExecTime(timeInterval.interval());
        this.insert(optLogBean);
        return result;
    }

    protected abstract OptUserBean getOptUserBean();

    protected abstract void insert(OptLogBean var1);
}

