/*
 * Decompiled with CFR 0.152.
 */
package cn.spider.framework.common.utils;

import cn.spider.framework.common.utils.SnowIdDto;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RAtomicLong;
import org.redisson.api.RedissonClient;

public class IdWorker {
    private static final Integer DATA_SIZE = 32;
    private static final String[] RADIX_STR = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v"};
    private static Map<String, Integer> RADIX_MAP = new LinkedHashMap<String, Integer>();
    private static final String SNOW = "SPIDER_SNOW";

    public static SnowIdDto calculateDataIdAndWorkId2(RedissonClient redissonClient, String appName) {
        String key = SNOW + appName;
        RAtomicLong atomicLong = redissonClient.getAtomicLong(key);
        long andIncrement = atomicLong.getAndIncrement();
        long result = andIncrement % (long)(DATA_SIZE * DATA_SIZE);
        String strResult = Integer.toString(Math.toIntExact(result), DATA_SIZE);
        String strResult2 = StringUtils.leftPad((String)strResult, (int)2, (String)"0");
        String substring1 = strResult2.substring(0, 1);
        String substring2 = strResult2.substring(1, 2);
        Integer dataId = RADIX_MAP.get(substring1);
        Integer workId = RADIX_MAP.get(substring2);
        SnowIdDto snowIdDto = new SnowIdDto(System.currentTimeMillis(), dataId, workId);
        return snowIdDto;
    }

    public static int GetRandomNum(int num1, int num2) {
        int result = (int)((double)num1 + Math.random() * (double)(num2 - num1 + 1));
        return result;
    }

    static {
        for (int i = 0; i < DATA_SIZE; ++i) {
            RADIX_MAP.put(RADIX_STR[i], i);
        }
    }
}

