/*
 * Decompiled with CFR 0.152.
 */
package com.flow.cloud.spider_mybatis_plugin.Interceptors;

import com.flow.cloud.spider_mybatis_plugin.Interceptors.MyDefaultOperationType;
import com.flow.cloud.spider_mybatis_plugin.Interceptors.MyDeleteOperationType;
import com.flow.cloud.spider_mybatis_plugin.Interceptors.MyInsertOperationType;
import com.flow.cloud.spider_mybatis_plugin.Interceptors.MySelectOperationType;
import com.flow.cloud.spider_mybatis_plugin.Interceptors.MyUpdateOperationType;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class MyBatisInterceptor
implements Interceptor {
    public Object intercept(Invocation invocation) throws Throwable {
        Object parameterObject;
        Object[] args = invocation.getArgs();
        MappedStatement statement = (MappedStatement)args[0];
        BoundSql boundSql = statement.getBoundSql(parameterObject = args[1]);
        String sql = boundSql.getSql();
        if (sql == null || "".equals(sql)) {
            return invocation.proceed();
        }
        this.resetSql2Invocation(invocation, sql);
        return invocation.proceed();
    }

    private void resetSql2Invocation(Invocation invocation, String sql) throws SQLException, IllegalAccessException {
        Object[] args = invocation.getArgs();
        MappedStatement statement = (MappedStatement)args[0];
        Object parameterObject = args[1];
        Map<String, Object> objectMap = this.getObjectToMap(parameterObject);
        MapperMethod.ParamMap paramMap = (MapperMethod.ParamMap)objectMap;
        BoundSql boundSql = statement.getBoundSql(parameterObject);
        List parameterMappings = boundSql.getParameterMappings();
        String newsql = "";
        MyDefaultOperationType myOperationType = null;
        switch (statement.getSqlCommandType()) {
            case INSERT: {
                myOperationType = new MyInsertOperationType();
                newsql = myOperationType.handle(statement, parameterMappings, paramMap, sql);
                args[1] = paramMap;
                break;
            }
            case UPDATE: {
                myOperationType = new MyUpdateOperationType();
                newsql = myOperationType.handle(statement, parameterMappings, paramMap, sql);
                break;
            }
            case DELETE: {
                myOperationType = new MyDeleteOperationType();
                newsql = myOperationType.handle(statement, parameterMappings, paramMap, sql);
                break;
            }
            case SELECT: {
                myOperationType = new MySelectOperationType();
                newsql = myOperationType.handle(statement, parameterMappings, paramMap, sql);
                break;
            }
        }
        BoundSql newBoundSql = new BoundSql(statement.getConfiguration(), newsql, parameterMappings, parameterObject);
        MappedStatement newStatement = this.copyFromMappedStatement(statement, new BoundSqlSqlSource(newBoundSql));
        args[0] = newStatement;
        System.out.println("sql\u8bed\u53e5\uff1a" + newsql);
    }

    private MappedStatement copyFromMappedStatement(MappedStatement ms, SqlSource newSqlSource) {
        MappedStatement.Builder builder = new MappedStatement.Builder(ms.getConfiguration(), ms.getId(), newSqlSource, ms.getSqlCommandType());
        builder.resource(ms.getResource());
        builder.fetchSize(ms.getFetchSize());
        builder.statementType(ms.getStatementType());
        builder.keyGenerator(ms.getKeyGenerator());
        if (ms.getKeyProperties() != null && ms.getKeyProperties().length != 0) {
            StringBuilder keyProperties = new StringBuilder();
            for (String keyProperty : ms.getKeyProperties()) {
                keyProperties.append(keyProperty).append(",");
            }
            keyProperties.delete(keyProperties.length() - 1, keyProperties.length());
            builder.keyProperty(keyProperties.toString());
        }
        builder.timeout(ms.getTimeout());
        builder.parameterMap(ms.getParameterMap());
        builder.resultMaps(ms.getResultMaps());
        builder.resultSetType(ms.getResultSetType());
        builder.cache(ms.getCache());
        builder.flushCacheRequired(ms.isFlushCacheRequired());
        builder.useCache(ms.isUseCache());
        return builder.build();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    public Map<String, Object> getObjectToMap(Object obj) throws IllegalAccessException {
        MapperMethod.ParamMap map = new MapperMethod.ParamMap();
        Class<?> clazz = obj.getClass();
        for (Field field : clazz.getDeclaredFields()) {
            field.setAccessible(true);
            String fieldName = field.getName();
            Object value = field.get(obj);
            if (value == null) {
                value = "";
            }
            map.put(fieldName, value);
        }
        return map;
    }

    class BoundSqlSqlSource
    implements SqlSource {
        private BoundSql boundSql;

        public BoundSqlSqlSource(BoundSql boundSql) {
            this.boundSql = boundSql;
        }

        public BoundSql getBoundSql(Object parameterObject) {
            return this.boundSql;
        }
    }
}

