/*
 * Decompiled with CFR 0.152.
 */
package cn.spider.framework.common.event;

import cn.spider.framework.common.event.EventType;
import cn.spider.framework.common.event.data.EventData;
import cn.spider.framework.common.utils.BrokerInfoUtil;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.json.JsonObject;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventManager {
    private static final Logger log = LoggerFactory.getLogger(EventManager.class);
    private EventBus eventBus;
    private String brokerName;

    public EventManager(Vertx vertx) {
        this.eventBus = vertx.eventBus();
        this.brokerName = BrokerInfoUtil.queryBrokerName(vertx);
    }

    public void sendMessage(EventType eventType, EventData eventData) {
        DeliveryOptions options = new DeliveryOptions();
        options.addHeader("BROKER_NAME", this.brokerName);
        options.addHeader("EVENT_NAME", eventType.getName());
        eventData.setTime(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
        JsonObject param = JsonObject.mapFrom((Object)eventData);
        String paramString = param.toString();
        String addr = eventType.queryAddr();
        this.eventBus.publish(addr, (Object)paramString, options);
    }
}

