/*
 * Decompiled with CFR 0.152.
 */
package cn.sparrowmini.bpm.service;

import cn.sparrowmini.bpm.model.ProcessForm;
import cn.sparrowmini.bpm.model.ProcessFormId;
import cn.sparrowmini.bpm.model.PublishedProcess;
import cn.sparrowmini.bpm.model.TaskForm;
import cn.sparrowmini.bpm.model.TaskFormId;
import cn.sparrowmini.bpm.repository.ProcessFormRepository;
import cn.sparrowmini.bpm.repository.PublishedProcessRepository;
import cn.sparrowmini.bpm.repository.TaskFormRepository;
import cn.sparrowmini.bpm.service.FlowFormService;
import cn.sparrowmini.form.model.SparrowForm;
import cn.sparrowmini.form.repository.FormRepository;
import java.util.List;
import java.util.Set;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class FlowFormServiceImpl
implements FlowFormService {
    @Autowired
    private ProcessFormRepository processFormRepository;
    @Autowired
    private TaskFormRepository taskFormRepository;
    @Autowired
    private FormRepository formRepository;
    @Autowired
    private PublishedProcessRepository publishedProcessRepository;

    @Override
    @Transactional
    public void createProcessForm(ProcessFormId processFormId, SparrowForm form) {
        if (this.processFormRepository.existsById(processFormId)) {
            ProcessForm processForm = (ProcessForm)this.processFormRepository.getReferenceById(processFormId);
            SparrowForm sparrowForm = (SparrowForm)this.formRepository.getReferenceById((Object)processForm.getFormId());
            sparrowForm.setOpenType(form.getOpenType());
            sparrowForm.setForm(form.getForm());
            sparrowForm.setName(form.getName());
            sparrowForm.setCode(form.getCode());
            this.processFormRepository.save(processForm);
            this.formRepository.save((Object)sparrowForm);
        } else {
            this.formRepository.save((Object)form);
            ProcessForm processForm = new ProcessForm(processFormId);
            processForm.setFormId(form.getId());
            this.processFormRepository.save(processForm);
        }
    }

    @Override
    public void createTaskForm(TaskFormId taskFormId, SparrowForm form) {
        if (this.taskFormRepository.existsById(taskFormId)) {
            TaskForm taskForm = (TaskForm)this.taskFormRepository.getReferenceById(taskFormId);
            SparrowForm sparrowForm = (SparrowForm)this.formRepository.getReferenceById((Object)taskForm.getFormId());
            sparrowForm.setOpenType(form.getOpenType());
            sparrowForm.setForm(form.getForm());
            sparrowForm.setName(form.getName());
            sparrowForm.setCode(form.getCode());
            this.taskFormRepository.save(taskForm);
            this.formRepository.save((Object)sparrowForm);
        } else {
            this.formRepository.save((Object)form);
            TaskForm taskForm = new TaskForm(taskFormId);
            taskForm.setFormId(form.getId());
            this.taskFormRepository.save(taskForm);
        }
    }

    @Override
    public ProcessForm getProcessForm(ProcessFormId id) {
        return this.processFormRepository.findById(id).orElse(null);
    }

    @Override
    public TaskForm getTaskForm(TaskFormId id) {
        return this.taskFormRepository.findById(id).orElse(null);
    }

    @Override
    @Transactional
    public void publishProcess(List<PublishedProcess> processes) {
        this.publishedProcessRepository.saveAll(processes);
    }

    @Override
    @Transactional
    public void unPublishProcess(List<String> processIds) {
        this.publishedProcessRepository.deleteAllById(processIds);
    }

    @Override
    public Page<PublishedProcess> getTaskForm(Pageable pageable) {
        return this.publishedProcessRepository.findAll(pageable);
    }

    @Override
    public void assignProcessForm(ProcessFormId processFormId, String formId) {
        ProcessForm processForm = (ProcessForm)this.processFormRepository.getReferenceById(processFormId);
        processForm.setFormId(formId);
        this.processFormRepository.save(processForm);
    }

    @Override
    public void deleteProcessForm(Set<ProcessFormId> processFormIds) {
        this.processFormRepository.deleteAllById(processFormIds);
    }

    @Override
    public void assignTaskForm(TaskFormId taskFormId, String formId) {
        TaskForm taskForm = (TaskForm)this.taskFormRepository.getReferenceById(taskFormId);
        taskForm.setFormId(formId);
        this.taskFormRepository.save(taskForm);
    }

    @Override
    public void deleteTaskForm(Set<TaskFormId> taskFormIds) {
        this.taskFormRepository.deleteAllById(taskFormIds);
    }
}

