/*
 * Decompiled with CFR 0.152.
 */
package cn.spark2fire.auth.token;

import cn.spark2fire.auth.config.AuthProperties;
import cn.spark2fire.auth.dto.UserToken;
import cn.spark2fire.auth.exception.UserUnauthorizedException;
import cn.spark2fire.auth.token.Token;
import cn.spark2fire.auth.token.TokenService;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.security.Keys;
import java.nio.charset.Charset;
import java.security.Key;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.SecretKey;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tH\u0016J \u0010\u000e\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\tH\u0016J\b\u0010\u0015\u001a\u00020\u0006H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcn/spark2fire/auth/token/JwtTokenService;", "Lcn/spark2fire/auth/token/TokenService;", "properties", "Lcn/spark2fire/auth/config/AuthProperties;", "(Lcn/spark2fire/auth/config/AuthProperties;)V", "key", "Ljava/security/Key;", "repository", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcn/spark2fire/auth/token/Token;", "deleteToken", "", "username", "encodeToken", "authority", "rememberMe", "", "extractToken", "Lcn/spark2fire/auth/dto/UserToken;", "rawToken", "getKey", "auth-jwt"})
public final class JwtTokenService
implements TokenService {
    private final ConcurrentHashMap<String, Token> repository;
    private final Key key;
    private final AuthProperties properties;

    private final Key getKey() {
        Key key;
        CharSequence charSequence = this.properties.getJwt().getSecretKey();
        boolean bl = false;
        if (charSequence.length() > 0) {
            charSequence = this.properties.getJwt().getSecretKey();
            Charset charset = Charsets.UTF_8;
            boolean bl2 = false;
            CharSequence charSequence2 = charSequence;
            if (charSequence2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = ((String)charSequence2).getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            SecretKey secretKey = Keys.hmacShaKeyFor((byte[])byArray);
            Intrinsics.checkNotNullExpressionValue((Object)secretKey, (String)"Keys.hmacShaKeyFor(prope\u2026.secretKey.toByteArray())");
            key = secretKey;
        } else {
            SecretKey secretKey = Keys.secretKeyFor((SignatureAlgorithm)SignatureAlgorithm.HS512);
            Intrinsics.checkNotNullExpressionValue((Object)secretKey, (String)"Keys.secretKeyFor(SignatureAlgorithm.HS512)");
            key = secretKey;
        }
        return key;
    }

    @NotNull
    public UserToken extractToken(@NotNull String rawToken) {
        Intrinsics.checkNotNullParameter((Object)rawToken, (String)"rawToken");
        try {
            Jws jws;
            Jws jws2 = jws = Jwts.parserBuilder().setSigningKey(this.key).requireIssuer(this.properties.getJwt().getIssuer()).requireSubject(this.properties.getJwt().getSubject()).requireAudience(this.properties.getJwt().getAudience()).build().parseClaimsJws(rawToken);
            Intrinsics.checkNotNullExpressionValue((Object)jws2, (String)"jws");
            String username = (String)((Claims)jws2.getBody()).get("username", String.class);
            String authority = (String)((Claims)jws.getBody()).get("authority", String.class);
            String string = username;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"username");
            return new UserToken(string, (Collection)SetsKt.setOf((Object)new SimpleGrantedAuthority(authority)), rawToken);
        }
        catch (Exception e) {
            throw (Throwable)new UserUnauthorizedException("Token\u5931\u6548", (Throwable)e);
        }
    }

    @NotNull
    public String encodeToken(@NotNull String username, @NotNull String authority, boolean rememberMe) {
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)authority, (String)"authority");
        Instant now = Instant.now();
        Instant expire = rememberMe ? now.plus(this.properties.getJwt().getRememberDays(), ChronoUnit.DAYS) : now.plus(this.properties.getIdleTimeout(), ChronoUnit.MINUTES);
        String string = Jwts.builder().setId(UUID.randomUUID().toString()).setIssuer(this.properties.getJwt().getIssuer()).setSubject(this.properties.getJwt().getSubject()).setAudience(this.properties.getJwt().getAudience()).claim("username", (Object)username).claim("authority", (Object)authority).claim("rememberMe", (Object)rememberMe).setIssuedAt(Date.from(now)).setExpiration(Date.from(expire)).signWith(this.key).compact();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Jwts.builder()\n         \u2026               .compact()");
        return string;
    }

    public void deleteToken(@NotNull String username) {
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        this.repository.remove(username);
    }

    public JwtTokenService(@NotNull AuthProperties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        this.properties = properties;
        this.repository = new ConcurrentHashMap();
        this.key = this.getKey();
    }
}

