/*
 * Decompiled with CFR 0.152.
 */
package cn.spark2fire.auth.token;

import cn.spark2fire.auth.config.AuthProperties;
import cn.spark2fire.auth.dto.UserToken;
import cn.spark2fire.auth.exception.UserUnauthorizedException;
import cn.spark2fire.auth.token.TokenService;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcn/spark2fire/auth/token/RedisTokenService;", "Lcn/spark2fire/auth/token/TokenService;", "redisTemplate", "Lorg/springframework/data/redis/core/StringRedisTemplate;", "properties", "Lcn/spark2fire/auth/config/AuthProperties;", "(Lorg/springframework/data/redis/core/StringRedisTemplate;Lcn/spark2fire/auth/config/AuthProperties;)V", "deleteToken", "", "username", "", "encodeToken", "authority", "rememberMe", "", "extractToken", "Lcn/spark2fire/auth/dto/UserToken;", "rawToken", "auth-redis"})
public final class RedisTokenService
implements TokenService {
    private final StringRedisTemplate redisTemplate;
    private final AuthProperties properties;

    @Nullable
    public UserToken extractToken(@NotNull String rawToken) {
        Intrinsics.checkNotNullParameter((Object)rawToken, (String)"rawToken");
        byte[] byArray = Base64.getDecoder().decode(rawToken);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"Base64.getDecoder().decode(rawToken)");
        byte[] byArray2 = byArray;
        boolean bl = false;
        String token = new String(byArray2, Charsets.UTF_8);
        String username = null;
        String authority = null;
        boolean rememberMe = false;
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)token, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] parts = stringArray;
        if (parts.length == 4) {
            username = parts[0];
            authority = parts[1];
            rememberMe = Intrinsics.areEqual((Object)"1", (Object)parts[2]);
        }
        if (username != null) {
            String key = this.properties.getRedisPrefix() + username;
            String accessToken = (String)this.redisTemplate.opsForValue().get((Object)key);
            if (Intrinsics.areEqual((Object)rawToken, (Object)accessToken)) {
                if (!rememberMe) {
                    this.redisTemplate.expire((Object)key, this.properties.getIdleTimeout(), TimeUnit.MINUTES);
                }
                return new UserToken(username, (Collection)SetsKt.setOf((Object)new SimpleGrantedAuthority(authority)), token);
            }
            throw (Throwable)new UserUnauthorizedException("Token\u5931\u6548", 40100);
        }
        return null;
    }

    @NotNull
    public String encodeToken(@NotNull String username, @NotNull String authority, boolean rememberMe) {
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)authority, (String)"authority");
        String token = username + ":" + authority + ":" + (rememberMe ? 1 : 0) + ":" + UUID.randomUUID();
        Base64.Encoder encoder = Base64.getEncoder();
        String string = token;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        String string3 = encoder.encodeToString(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"Base64.getEncoder().enco\u2026ring(token.toByteArray())");
        token = string3;
        String key = this.properties.getRedisPrefix() + username;
        this.redisTemplate.opsForValue().set((Object)key, (Object)token);
        if (!rememberMe) {
            this.redisTemplate.expire((Object)key, this.properties.getIdleTimeout(), TimeUnit.MINUTES);
        }
        return token;
    }

    public void deleteToken(@NotNull String username) {
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        this.redisTemplate.delete((Object)(this.properties.getRedisPrefix() + username));
    }

    public RedisTokenService(@NotNull StringRedisTemplate redisTemplate, @NotNull AuthProperties properties) {
        Intrinsics.checkNotNullParameter((Object)redisTemplate, (String)"redisTemplate");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        this.redisTemplate = redisTemplate;
        this.properties = properties;
    }
}

