/*
 * Decompiled with CFR 0.152.
 */
package cn.spark2fire.auth.token;

import cn.spark2fire.auth.config.AuthProperties;
import cn.spark2fire.auth.dto.UserToken;
import cn.spark2fire.auth.exception.UserUnauthorizedException;
import cn.spark2fire.auth.token.Token;
import cn.spark2fire.auth.token.TokenService;
import java.nio.charset.Charset;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcn/spark2fire/auth/token/DatabaseTokenService;", "Lcn/spark2fire/auth/token/TokenService;", "jdbcTemplate", "Lorg/springframework/jdbc/core/JdbcTemplate;", "properties", "Lcn/spark2fire/auth/config/AuthProperties;", "(Lorg/springframework/jdbc/core/JdbcTemplate;Lcn/spark2fire/auth/config/AuthProperties;)V", "deleteToken", "", "username", "", "encodeToken", "authority", "rememberMe", "", "extractToken", "Lcn/spark2fire/auth/dto/UserToken;", "rawToken", "auth-db"})
public final class DatabaseTokenService
implements TokenService {
    private final JdbcTemplate jdbcTemplate;
    private final AuthProperties properties;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public UserToken extractToken(@NotNull String rawToken) {
        void username;
        Intrinsics.checkNotNullParameter((Object)rawToken, (String)"rawToken");
        byte[] byArray = Base64.getDecoder().decode(rawToken);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"Base64.getDecoder().decode(rawToken)");
        Object object = byArray;
        boolean bl = false;
        String token = new String((byte[])object, Charsets.UTF_8);
        object = new Ref.ObjectRef();
        object.element = null;
        String authority = null;
        boolean rememberMe = false;
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)token, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] parts = stringArray;
        if (parts.length == 4) {
            username.element = parts[0];
            authority = parts[1];
            rememberMe = Intrinsics.areEqual((Object)"1", (Object)parts[2]);
        }
        if ((String)username.element != null) {
            Timestamp now = Timestamp.from(Instant.now());
            List list = this.jdbcTemplate.query("SELECT token,activeTime FROM " + this.properties.getTableName() + " WHERE username=?", (RowMapper)new RowMapper<Token>((Ref.ObjectRef)username){
                final /* synthetic */ Ref.ObjectRef $username;

                @Nullable
                public final Token mapRow(@NotNull ResultSet rs, int $noName_1) {
                    Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
                    String string = (String)this.$username.element;
                    String string2 = rs.getString("token");
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"rs.getString(\"token\")");
                    Instant instant = rs.getTimestamp("activeTime").toInstant();
                    Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"rs.getTimestamp(\"activeTime\").toInstant()");
                    return new Token(string, string2, instant);
                }
                {
                    this.$username = objectRef;
                }
            }, new Object[]{(String)username.element});
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"jdbcTemplate.query(\"SELE\u2026             }, username)");
            Token accessToken2 = (Token)CollectionsKt.firstOrNull((List)list);
            if (accessToken2 != null && Intrinsics.areEqual((Object)rawToken, (Object)accessToken2.getToken()) && accessToken2.getActiveTime().plus(this.properties.getIdleTimeout(), ChronoUnit.MINUTES).isAfter(now.toInstant())) {
                if (!rememberMe) {
                    this.jdbcTemplate.update("UPDATE " + this.properties.getTableName() + " SET activeTime=? WHERE username=?", new Object[]{now, (String)username.element});
                }
                return new UserToken((String)username.element, (Collection)SetsKt.setOf((Object)new SimpleGrantedAuthority(authority)), token);
            }
            throw (Throwable)new UserUnauthorizedException("Token\u5931\u6548", 40100);
        }
        return null;
    }

    @NotNull
    public String encodeToken(@NotNull String username, @NotNull String authority, boolean rememberMe) {
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)authority, (String)"authority");
        this.deleteToken(username);
        String token = username + ":" + authority + ":" + (rememberMe ? 1 : 0) + ":" + UUID.randomUUID();
        Base64.Encoder encoder = Base64.getEncoder();
        String string = token;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        String string3 = encoder.encodeToString(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"Base64.getEncoder().enco\u2026ring(token.toByteArray())");
        token = string3;
        Timestamp now = Timestamp.from(Instant.now());
        this.jdbcTemplate.update("INSERT INTO " + this.properties.getTableName() + " (username,token,activeTime,createTime) VALUES (?,?,?,?)", new Object[]{username, token, now, now});
        return token;
    }

    public void deleteToken(@NotNull String username) {
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        this.jdbcTemplate.update("DELETE FROM " + this.properties.getTableName() + " WHERE username=?", new Object[]{username});
    }

    public DatabaseTokenService(@NotNull JdbcTemplate jdbcTemplate, @NotNull AuthProperties properties) {
        Intrinsics.checkNotNullParameter((Object)jdbcTemplate, (String)"jdbcTemplate");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        this.jdbcTemplate = jdbcTemplate;
        this.properties = properties;
    }
}

