package cn.sowjz.search.tools;

import cn.sowjz.search.core.SearchClient;
import cn.sowjz.search.core.db.FieldInfo;
import cn.sowjz.search.core.db.Schema;
import cn.sowjz.search.core.doc.Doc;
import cn.sowjz.search.core.query.request.QueryRequest;
import cn.sowjz.search.core.query.response.QueryResponse;
import cn.sowjz.search.core.query.response.UpdateResponse;
import cn.sowjz.search.core.util.DocUpdateChecker;

public class UpdateTool {

	SearchClient ss;
	public UpdateTool(SearchClient ss){
		this.ss=ss;
	}
	/**
	 * 构造一个Doc对象，添加目标数据SEQ字段，然后增加需要改变的字段值。
	 * 
	 * */
	
	public int update(Doc one) throws Exception{
		Schema schema = ss.getSchema();
		FieldInfo idFI = schema.getSeqFI();
		if(one.getAsLong(idFI.getName())==null)
			throw new Exception("value of "+idFI.getName()+" is null");
		if(new DocUpdateChecker().canQuickUpdate(one)){
			
			QueryRequest req = new QueryRequest(ss);
			req.createCriteria().andEqual(idFI.getName(), one.getAslong(idFI.getName()));
			UpdateResponse n=ss.update(req, one);
			return (int) n.getUpdateNum();
		}
		
		QueryRequest requ = new QueryRequest(ss, QueryRequest.OrderBy.time, QueryRequest.SumType.count);
		requ.createCriteria().andEqual(idFI.getName(), one.getAslong(idFI.getName()));
		QueryResponse hits = ss.query(requ);
		if(hits.getDocNum()>0){
			Doc a=hits.get(0).getDoc();
			a.copy(one);
			one=a;
			ss.delDoc(requ);
		}
		ss.addDoc(one);
		return 1;
	}
}
