package cn.sowjz.search.tools;

import java.util.Map;

import cn.sowjz.search.core.SearchClient;
import cn.sowjz.search.core.db.FieldInfo;
import cn.sowjz.search.core.net.control.QueryConn;
import cn.sowjz.search.core.query.request.BaseRequest.SumType;
import cn.sowjz.search.core.query.request.QueryRequest;
import cn.sowjz.search.core.query.response.DbSeqScope;
import cn.sowjz.search.core.query.response.DbSeqScope.SeqScope;
import cn.sowjz.search.core.query.response.QueryResponse;


/**
 * 
 * 该方法的使用前提是，加载是ID小的先加载
 * */
public class Traverser {
	SearchClient ss;
	Handler handler;
	int askNum;
	FieldInfo seqfi;
	public Traverser(SearchClient ss,Handler handler,int askNum) {
		this.ss=ss;
		this.handler=handler;
		this.askNum=askNum;
		if(ss.getSchema()!=null)
			seqfi=ss.getSchema().getSeqFI();
	}
	
	public static  interface Handler{

		public QueryRequest buildQueryRequest() throws Exception;

		public void onQueryResult(QueryResponse hits)throws Exception;

		public void onDbSeqScope(DbSeqScope scope)throws Exception;
		
	}
	
	/**
	 * idOver :已经遍历过的id，key：host_sn
	 * */
	public void runOnce(Map<Integer,Long> idOver)throws Exception{
		
		QueryConn conn=ss.createQueryConn();
		try{
			DbSeqScope scope = ss.querySeqScope(conn);
			scope.checkDupHostSN();
			handler.onDbSeqScope(scope);
			
			
			for(int i=0;i<scope.getNum();i++){
				SeqScope ssp = scope.getScope(i);
				
				if(ssp.run_ok==0)
				{
					while(ssp.min<ssp.max)
						one(conn,ssp,idOver);
				}	
			}	
				
		}catch(Exception e)
		{
			conn.close();
			throw e;
		}
		conn.close();
		
		
	}

	private void one(QueryConn conn,SeqScope ssp, Map<Integer, Long> idOver) throws Exception {
		QueryRequest req=handler.buildQueryRequest();
		req.setFocusOn(ssp.host_sn);
		long min=ssp.min;
		Long _m=idOver.get(ssp.host_sn);
		if(_m!=null){
			min=_m;ssp.min=min;
		}	
		if(ssp.max<=min)
			return;
		
		req.createCriteria().andBetween(seqfi.getName(), min, ssp.max);
		req.setOrderByFieldAsc( seqfi.getName());
		req.setSumType(SumType.count);
		req.setAskNum(askNum);
		req.setStart(0);
		
		QueryResponse hits = ss.query(conn,req);
		if(hits.getDocNum()==0)
		{
			ssp.min=ssp.max+1;
			
		}else if(hits.getDocNum()==askNum)	
		{
			ssp.min=hits.get(askNum-1).getDoc().getSequenceFieldValue() +1;
			
		}else	
			ssp.min=ssp.max+1;
		
		idOver.put(ssp.host_sn,ssp.min);
		
		if(hits.getDocNum()>0)
			handler.onQueryResult(hits);
		
	}
	
}
