package cn.sowjz.search.prism.net;

import cn.sowjz.search.common.ByteBuff;
import cn.sowjz.search.core.SearchClient;
import cn.sowjz.search.core.conf.SearchConfig;
import cn.sowjz.search.core.net.control.BaseConn;
import cn.sowjz.search.core.net.control.ControlerVariable;

public class PrismConn extends BaseConn {

	public PrismConn(String ip, int port, int timeout) {
		super(ip, port, timeout);
		cmd_protocol="prism";
	}
	public PrismConn(SearchConfig cfg) {
		super(cfg.getSockIp(),cfg.getQuerySockPort(),cfg.getSocketTimeOut());
		cmd_protocol="prism";
	}
	boolean first_connect=true;

	@Override
	protected ByteBuff buildCommand(int opt)
	{
		ByteBuff bb =new ByteBuff();
		if(first_connect)
		{	
			bb.append(("BINARY /ver"+SearchClient.Api_Version+" prism\n").getBytes());
			for(int i=bb.getUsed();i<Header_Len;i++)
				bb.append((byte)0);	
			first_connect=false;
		}
		else
			bb.append(ControlerVariable.LOOPACK);
		bb.append(opt);
		
		return bb;
	}
	@Override
	public void close() {
	//	if(!first_connect)
		try
		{
			mysock.send(ControlerVariable.ACK);
			log.info("send socket close sign");
			
		}catch(Exception e)
		{
			log.error(e);
		}
		try
		{
			mysock.close();
			mysock=null;
		}catch(Exception e)
		{
			log.error(e);
		}
		log.info("BaseConn close finish");
	}

	
	
	
}
