package cn.sowjz.search.prism.net;

import java.util.ArrayList;
import java.util.List;

import cn.sowjz.search.common.ByteBuff;
import cn.sowjz.search.common.VConvert;
import cn.sowjz.search.common.util.charset.String2Bytes;
import cn.sowjz.search.core.doc.Doc;
import cn.sowjz.search.core.net.control.BaseConn;
import cn.sowjz.search.core.net.control.ControlerVariable;
import cn.sowjz.search.core.query.request.BaseRequest;
import cn.sowjz.search.core.query.request.CritHeader;
import cn.sowjz.search.core.query.request.QueryRequest;
import cn.sowjz.search.core.query.response.WordCloudResponse;
import cn.sowjz.search.prism.PrismClient;
import cn.sowjz.search.prism.query.DocMatched;

public class AskPrism {
	BaseConn conn;
	public AskPrism(BaseConn conn) {
		this.conn=conn;
	}

	public Boolean changeToEditMode() throws Exception {
		byte [] buf=conn.runCommand(ControlerVariable.OPT_PRISM_EDIT_MODE);
		if(buf==null )return null;
		return  buf[0]==1;
	}
	public Boolean changeToWorkMode() throws Exception {
		byte [] buf=conn.runCommand(ControlerVariable.OPT_PRISM_WORK_MODE);
		if(buf==null )return null;
		return  buf[0]==1;
	}
	
	public Integer clearQuery() throws Exception {
		byte [] buf=conn.runCommand(ControlerVariable.OPT_PRISM_CLEAR_QUERY);
		if(buf==null )return null;
		return VConvert.bytes2Int(buf);
	}
	public Integer addQuery(BaseRequest req) throws Exception {
		ByteBuff bb=req.toByteBuff();
		byte [] buf=conn.runCommand(ControlerVariable.OPT_PRISM_ADD_QUERY,bb.array(),bb.getUsed());
		if(buf==null )return null;
		return VConvert.bytes2Int(buf);
	}
	public Integer addQueryWithID(BaseRequest req,int id) throws Exception {
		ByteBuff bb=new ByteBuff();
		bb.append(id);
		bb.append(req.toByteBuff());
		byte [] buf=conn.runCommand(ControlerVariable.OPT_PRISM_ADD_QUERY_WITH_ID,bb.array(),bb.getUsed());
		if(buf==null )return null;
		return VConvert.bytes2Int(buf);
	}
	public DocMatched<int[]> docRun(Doc doc) throws Exception {
		ByteBuff bb = doc.toByteBuff();
	
		byte [] buf=conn.runCommand(ControlerVariable.OPT_PRISM_DOC_RUN,bb.array(),bb.getUsed());
		if(buf==null )throw new Exception(conn.getErrMsg());
		
		DocMatched<int[]> dm=new DocMatched<int[]>();
		
		// -1:edit_mode, >=0 query number
		int mode= VConvert.bytes2Int(buf);
		if(mode<=0){
			dm.setResult(DocMatched.MODE_WRONG);
			return dm;
		}
		int num=VConvert.bytes2Int(buf,4);
		int v[]=new int[num];
		for(int i=0;i<num;i++){
			v[i]=VConvert.bytes2Int(buf,8+4*i);
		}
		dm.setQueryIDs(v);
		return  dm;
	}
	public DocMatched<List<int[]>> docRun(List<? extends Doc> list) throws Exception {
		
		
		ByteBuff bb = new ByteBuff();
		
		
		for (Doc ar:list)
		{
			ByteBuff tmp = ar.toByteBuff();
			if(tmp==null)
				continue;
			
			bb.append(tmp.getUsed()).append(tmp);
		}
		
		
		byte [] buf=conn.runCommand(ControlerVariable.OPT_PRISM_DOC_LIST_RUN,bb.array(),bb.getUsed());
		if(buf==null )throw new Exception(conn.getErrMsg());
		
		// -1:edit_mode, >=0 query number
		
		DocMatched<List<int[]>> dm=new DocMatched<List<int[]>>();
		
		int mode= VConvert.bytes2Int(buf);
		if(mode<0){
			dm.setResult(DocMatched.MODE_WRONG);
			return dm;
		}
		dm.setResult(DocMatched.SUCCESS);
		int doc_num=VConvert.bytes2Int(buf,4);
		
		List<int[]> l=new ArrayList<int[]>(doc_num);
		dm.setQueryIDs(l);
		
		int start=8;
		for(int j=0;j<doc_num;j++){
		
			int num=VConvert.bytes2Int(buf,start);
			start+=4;
			int v[]=new int[num];
			for(int i=0;i<num;i++){
				v[i]=VConvert.bytes2Int(buf,start);
				start+=4;
			}
			l.add(v);
		}
		return dm;
	}
	public WordCloudResponse wordCould(CritHeader th, List<String> txts, PrismClient prismSystem) throws Exception {
		String2Bytes str2bytes=String2Bytes.getInstance(prismSystem.getCharset());
		ByteBuff bb=new ByteBuff();
		th.toByteBuffer(bb);
		bb.append(txts.size());
		for(String s:txts){
			byte []vb=str2bytes.toBytes(s);
			
			bb.append(vb.length+1);
			bb.append(vb);
			bb.append((byte)0);
		}
		byte [] buf=conn.runCommand(ControlerVariable.OPT_PRISM_WORD_CLOUD,bb.array(),bb.getUsed());
		if(buf==null)throw new Exception(conn.getErrMsg());
		WordCloudResponse hits = new WordCloudResponse(prismSystem);
		hits.bytes2Me(buf);
		return hits;
	}
	
	
	
}
