package cn.sowjz.search.prism;

import java.util.List;

import cn.sowjz.search.core.ISearchException;
import cn.sowjz.search.core.SearchBase;
import cn.sowjz.search.core.conf.SearchConfig;
import cn.sowjz.search.core.conf.SpecialIdxParser;
import cn.sowjz.search.core.db.Schema;
import cn.sowjz.search.core.doc.Doc;
import cn.sowjz.search.core.exception.NoDBException;
import cn.sowjz.search.core.exception.SysConnectionException;
import cn.sowjz.search.core.net.control.AskQuery;
import cn.sowjz.search.core.net.control.BaseConn;
import cn.sowjz.search.core.net.pool.ConnPool;
import cn.sowjz.search.core.net.pool.ISearchConnPool;
import cn.sowjz.search.core.net.pool.NoPool;
import cn.sowjz.search.core.query.request.BaseRequest;
import cn.sowjz.search.core.query.request.CritHeader;
import cn.sowjz.search.core.query.request.QueryRequest;
import cn.sowjz.search.core.query.response.WordCloudResponse;
import cn.sowjz.search.prism.conf.PrismConfig;
import cn.sowjz.search.prism.net.AskPrism;
import cn.sowjz.search.prism.net.PrismConn;
import cn.sowjz.search.prism.net.PrismConnBuilder;
import cn.sowjz.search.prism.query.DocMatched;

public class PrismClient extends SearchBase {
	public static boolean open_on_create=true;

	private ConnPool<PrismConn>  pconn_pool= null;
	public final static int Prism_Version_Support=109;
	
	public final static int EDIT_MODE=1;
	public final static int WORK_MODE=2;
	public final static String Mode_Names[]=new String[]{null,"EDIT_MODE","WORK_MODE"};
	
	public PrismClient(PrismConfig conf) throws Exception {
		this.cfg=conf;
		init_PrismConnPool(cfg);
			
		if(open_on_create) open();
		sparser =  new SpecialIdxParser(cfg.getProps());
	}
	
	
	
	
	
	
	private void init_PrismConnPool(SearchConfig cfg) throws Exception {
		if(cfg.getPropertyOfboolean("system.net.sock.query.pool.enable"))
			pconn_pool=new ISearchConnPool<PrismConn>(new PrismConnBuilder(),
					cfg.getPropertyOfint("system.net.sock.query.pool.maxActive"),
					cfg.getPropertyOfint("system.net.sock.query.pool.maxIdle"),
					cfg.getPropertyOflong("system.net.sock.query.pool.maxWait.ms"),
					cfg.getPropertyOfint("system.net.sock.query.pool.idleRemoveDelay.second"),
					cfg.getPropertyOflong("system.net.sock.query.pool.pulse.second")*1000
					);
		else	
			pconn_pool=new NoPool<PrismConn>(new PrismConnBuilder());
		pconn_pool.initialize(cfg);
	}
	public void destroy() {
		pconn_pool.destroy();
		log.info("prism api destory");
	}
	
	
	public PrismConn openConn() throws Exception{
		return pconn_pool.getConn();
	}
	
	public void closeConn(PrismConn conn) throws Exception{
		pconn_pool.releaseConn(conn);
	}
	
	 protected void open() throws Exception
		{
			log.info("Opening system .");
			PrismConn conn=pconn_pool.getConn();
			try
			{
				testServerConnection(conn);
			} catch (Exception ex)
			{
				pconn_pool.releaseConn(conn,ex);
				log.error("open system error : " + ex.getMessage());
				throw new SysConnectionException(ex.getMessage());
			}
			readFeedInfo(conn);
			
			try
			{
				schema = descDb(conn);
			} catch (Exception ex)
			{
				pconn_pool.releaseConn(conn,ex);
				log.warn("open system warn(descDb()): " + ex.getMessage());
				// Ingore;
				return;
			}
			
			
			pconn_pool.releaseConn(conn);
			log.info("System has been opened.");
			
		}
	
	public Schema descDb() throws Exception
	{
		if (schema == null)
		{
			PrismConn conn=pconn_pool.getConn();
			try
			{
			schema = descDb(conn);
			}catch(Exception e)
			{
				pconn_pool.releaseConn(conn,e);
				throw e;
			}
			pconn_pool.releaseConn(conn);
			
			log.info("Query DB Struction Success.");
		}
		return schema;
	}
	public Schema descDb(BaseConn conn) throws Exception
	{
		if (schema == null)
		{
			schema = new AskQuery(conn).descDb(feedinfo.getCharset());
			if(schema==null)throw new ISearchException(conn.getErrCode(),conn.getErrMsg());
			log.info("Query DB Struction Success.");
		}
		
		return schema;
	}
	
	protected void readFeedInfo(BaseConn conn)throws Exception {
		
		feedinfo=new AskQuery(conn).feedInfo();
		
		if(feedinfo==null)
			throw new Exception("read feed info from "+cfg.getSockIp()+":"+cfg.getQuerySockPort()+" failed");
		
		
		
		if(feedinfo.version % 1000<Prism_Version_Support)
			throw new Exception("The isearch version["+feedinfo.version+"] is low, this API doesnt support. the version of isearch should be or above "+Prism_Version_Support+".");
	}
	public int whichMode() throws Exception
	{
		int m=0;
		//log.info("Test Server Query Connection.");
		PrismConn conn=pconn_pool.getConn();
		try
		{
			m=whichMode(conn);
		}catch(Exception e)
		{
			pconn_pool.releaseConn(conn,e);
			throw e;
		}
		pconn_pool.releaseConn(conn);
		return m;
	}
	
	public int whichMode(BaseConn conn) throws Exception{
		feedinfo=new AskQuery(conn).feedInfo();
		if(feedinfo==null)throw new ISearchException(conn.getErrCode(),conn.getErrMsg());
		return feedinfo.indexStatus;
	}
	
	public void testServerConnection() throws Exception
	{
		//log.info("Test Server Query Connection.");
		PrismConn conn=pconn_pool.getConn();
		try
		{
			testServerConnection(conn);
		}catch(Exception e)
		{
			pconn_pool.releaseConn(conn,e);
			throw e;
		}
		pconn_pool.releaseConn(conn);
		
	}
	@Override
	public void testServerConnection(BaseConn conn) throws Exception
	{
		//log.info("Test Server Query Connection.");
		if(new AskQuery(conn).testConnection())
			log.info("Test Server Query Connection Successful .");
		else 
			throw new Exception("Test Server Query Connection failed! "+conn.getErrMsg());
			
	}
	
	public int addQuery(BaseRequest req,int id) throws Exception
	{
		int relt=0;
		PrismConn conn=pconn_pool.getConn();
		try
		{
			relt =addQuery(conn,req,id);
		}catch(Exception e)
		{
			pconn_pool.releaseConn(conn,e);
			throw e;
		}
		pconn_pool.releaseConn(conn);
		
		
		return relt;
	}
	public int addQuery(BaseConn conn,BaseRequest req,int id) throws Exception
	{
		if(id<0)
		{
			Exception ex = new Exception("id of Query <0");
			log.error(ex.getMessage());
			throw ex;
		}
		if (null == this.schema)
		{
			Exception ex = new NoDBException();
			log.error(ex.getMessage());
			throw ex;
		}
		
		Integer relt = new AskPrism(conn).addQueryWithID(req,id);
		if(relt==null)throw new ISearchException(conn.getErrCode(),conn.getErrMsg());
		log.info("Add Query Successful !");
		return relt;
	}
	
	public int addQuery(BaseRequest req) throws Exception
	{
		int relt=0;
		PrismConn conn=pconn_pool.getConn();
		try
		{
			relt =addQuery(conn,req);
		}catch(Exception e)
		{
			pconn_pool.releaseConn(conn,e);
			throw e;
		}
		pconn_pool.releaseConn(conn);
		
		
		return relt;
	}
	public int addQuery(BaseConn conn,BaseRequest req) throws Exception
	{
		if (null == this.schema)
		{
			Exception ex = new NoDBException();
			log.error(ex.getMessage());
			throw ex;
		}
		Integer relt = new AskPrism(conn).addQuery(req);
		if(relt==null)throw new ISearchException(conn.getErrCode(),conn.getErrMsg());
		log.info("Add Query Successful !");
		return relt;
	}
	
	public boolean changeToEditMode() throws Exception
	{
		boolean relt=false;
		PrismConn conn=pconn_pool.getConn();
		try
		{
			relt =changeToEditMode(conn);
		}catch(Exception e)
		{
			pconn_pool.releaseConn(conn,e);
			throw e;
		}
		pconn_pool.releaseConn(conn);
		
		
		return relt;
	}
	public boolean changeToEditMode(BaseConn conn) throws Exception
	{
		if (null == this.schema)
		{
			Exception ex = new NoDBException();
			log.error(ex.getMessage());
			throw ex;
		}
		Boolean relt = new AskPrism(conn).changeToEditMode();
		if(relt==null) throw new ISearchException(conn.getErrCode(),conn.getErrMsg());
		log.info("changeToEditMode Successful !");
		return relt;
	}
	public boolean changeToWorkMode() throws Exception
	{
		boolean relt=false;
		PrismConn conn=pconn_pool.getConn();
		try
		{
			relt =changeToWorkMode(conn);
		}catch(Exception e)
		{
			pconn_pool.releaseConn(conn,e);
			throw e;
		}
		pconn_pool.releaseConn(conn);
		
		
		return relt;
	}
	public boolean changeToWorkMode(BaseConn conn) throws Exception
	{
		if (null == this.schema)
		{
			Exception ex = new NoDBException();
			log.error(ex.getMessage());
			throw ex;
		}
		Boolean relt = new AskPrism(conn).changeToWorkMode();
		if(relt==null) throw new ISearchException(conn.getErrCode(),conn.getErrMsg());
		log.info("changeToWorkMode Successful !");
		return relt;
	}
	
	
	public int clearAllQuerys() throws Exception
	{
		int relt=0;
		PrismConn conn=pconn_pool.getConn();
		try
		{
			relt =clearAllQuerys(conn);
		}catch(Exception e)
		{
			pconn_pool.releaseConn(conn,e);
			throw e;
		}
		pconn_pool.releaseConn(conn);
		
		
		return relt;
	}
	public int clearAllQuerys(BaseConn conn) throws Exception
	{
		if (null == this.schema)
		{
			Exception ex = new NoDBException();
			log.error(ex.getMessage());
			throw ex;
		}
		Integer relt = new AskPrism(conn).clearQuery();
		if(relt==null) throw new ISearchException(conn.getErrCode(),conn.getErrMsg());
		log.info("clearAllQuerys Successful !");
		return relt;
	}
	public DocMatched<int[]> docRun(Doc doc) throws Exception
	{
		DocMatched<int[]> relt=null;
		PrismConn conn=pconn_pool.getConn();
		try
		{
			relt = docRun(conn,doc);
		}catch(Exception e)
		{
			pconn_pool.releaseConn(conn,e);
			throw e;
		}
		pconn_pool.releaseConn(conn);
		
		
		return relt;
	}
	public  DocMatched<int[]> docRun(BaseConn conn,Doc doc) throws Exception
	{
		if (null == this.schema)
		{
			Exception ex = new NoDBException();
			log.error(ex.getMessage());
			throw ex;
		}
		DocMatched<int[]> relt = new AskPrism(conn).docRun(doc);
		log.info("docRun Successful !");
		return relt;
	}
	public String getMode() {
		return feedinfo.indexStatus==EDIT_MODE?Mode_Names[EDIT_MODE]:Mode_Names[WORK_MODE];
	}
	public int getTotalQuerys(){ return feedinfo.feedBuffSize;}
	
	public DocMatched<List<int[]>> docRun( List<?extends Doc> list) throws Exception
	{
		DocMatched<List<int[]>> relt=null;
		PrismConn conn=pconn_pool.getConn();
		try
		{
			relt = docRun(conn,list);
		}catch(Exception e)
		{
			pconn_pool.releaseConn(conn,e);
			throw e;
		}
		pconn_pool.releaseConn(conn);
		
		
		return relt;
	}
	
	public DocMatched<List<int[]>> docRun(PrismConn conn, List<?extends Doc> list) throws Exception {
				if (null == this.schema)
				{
					Exception ex = new NoDBException();
					log.error(ex.getMessage());
					throw ex;
				}
				DocMatched<List<int[]>>relt = new AskPrism(conn).docRun(list);
				log.info("docRun Successful !");
				return relt;
	};
	
	public WordCloudResponse wordcloud(List<String>txts,int maxWord)throws Exception
	{
	
		WordCloudResponse hits =null;
		PrismConn conn=pconn_pool.getConn();
		try
		{
			hits =wordcloud(conn,txts, maxWord);
		}catch(Exception e)
		{
			pconn_pool.releaseConn(conn,e);
			throw e;
		}
		pconn_pool.releaseConn(conn);
		
		
		return hits;
	}
	public WordCloudResponse wordcloud(PrismConn conn,List<String>txts,int maxWord)throws Exception
	{
	
		log.info("word cloud  .");
		if (null == txts)
		{
			return null;
		}
		CritHeader th=new CritHeader(null,0,0);
		th.maxKeyWords=(short)maxWord;		
		
		WordCloudResponse hits =new AskPrism(conn).wordCould(th,txts,this);
		if(hits==null)throw new ISearchException(conn.getErrCode(),conn.getErrMsg());
		log.info("Query Doc Successful !");
		return hits;
	}
}
