package cn.sowjz.search.parser.req;

import java.io.StringReader;
import java.util.List;

import cn.sowjz.search.common.VConvert;
import cn.sowjz.search.common.util.ArrayUtil;
import cn.sowjz.search.core.SearchBase;
import cn.sowjz.search.core.SearchClient;
import cn.sowjz.search.core.db.FieldInfo;
import cn.sowjz.search.core.query.request.BaseRequest;
import cn.sowjz.search.core.query.request.ClusterRequest;
import cn.sowjz.search.core.query.request.Criteria;
import cn.sowjz.search.core.query.request.CubeRequest;
import cn.sowjz.search.core.query.request.DistinctRequest;
import cn.sowjz.search.core.query.request.GroupRequest;
import cn.sowjz.search.core.query.request.KeyWordRequest;
import cn.sowjz.search.core.query.request.QueryRequest;
import cn.sowjz.search.core.query.request.SamplingRequest;
import cn.sowjz.search.core.query.request.SubCrit;
import cn.sowjz.search.core.query.request.UnitedRequest;
import cn.sowjz.search.core.query.request.WamRequest;
import cn.sowjz.search.core.query.request.WordCloudRequest;
import cn.sowjz.search.parser.req.RequestParser.CmdType;
import cn.sowjz.search.parser.req.RequestParser.OpType;
import cn.sowjz.search.parser.req.RequestParser.SortType;
import cn.sowjz.search.parser.req.RequestParser.SumType;


public abstract class RequestBuilder {

	
	public abstract BaseRequest getRequest();
	
	public static class Simple extends RequestBuilder{

		@Override
		public void askBegin(String tx) {
			System.out.println("askBegin:"+tx);
		}

		@Override
		public void queryCmd(CmdType tx) {
			System.out.println("queryCmd:"+tx);
		}
		@Override
		public void askNum(String tx) {
			System.out.println("askNum:"+tx);
		}
		@Override
		public void target(String tx) {
			System.out.println("target:"+tx);
		}
		@Override
		public void groupBegin(String tx) {
			System.out.println("groupBegin:"+tx);
		}
		@Override
		public void groupStep(String tx) {
			System.out.println("groupStep:"+tx);
		}
		@Override
		public void orderBy(SortType tx) {
			System.out.println("orderBy:"+tx);
		}
		@Override
		public void orderBy(SortType type,String func){
			System.out.println("orderBy:"+type+":"+func);
		}
		@Override
		public void sum(SumType type){
			System.out.println("sum:"+type);
		}
		@Override
		public void fieldSum(List<String> sumlist){
			System.out.println("sum:"+sumlist.toString());
		}
		@Override
		public QueryRequest getRequest() {
			return null;
		}

		@Override
		public void createRequest() {
			
		}

		@Override
		public SubCrit oneFieldCrit(String fn, OpType op, String value) {
			
			SubCrit sub=new PSubCrit(fn+" "+op+" "+value).createSubCrit();
			return sub;
		}

		@Override
		public SubCrit oneFieldCrit(String image, OpType between, String beginV,
				String endV) {
			
			SubCrit sub=new PSubCrit(image+" "+between+" "+beginV+","+endV).createSubCrit();
			return sub;
		}

		@Override
		public SubCrit oneFieldCrit(String image, String op,  List<String> value) {
			SubCrit sub=new PSubCrit(image+" "+op+" "+value).createSubCrit();
			return sub;
		}
		@Override
		public void where(SubCrit subt) {
			// TODO Auto-generated method stub
			
		}

		@Override
		public void cube2f_max(String image) {
			System.out.println("cube2f_max:"+image);
			
		}

		@Override
		public void cube2fn(String image) {
			System.out.println("cube2fn:"+image);
			
		}

		@Override
		public void miningParams(List<String> list) {
			System.out.println("miningParams:"+list);
			
		}

		@Override
		public void simhash_threshold(String image) {
			System.out.println("simhash_threshold:"+image);
			
		}
		@Override
		public void table_name(String tablename) {
			System.out.println("tablename:"+tablename);
			
		}
	
		@Override
		public RunResult runRequest(SearchClient ss) {
			// TODO Auto-generated method stub
			return null;
		}

		
	}
	
	
	
	public static class X extends RequestBuilder{

		SearchBase sb;
		BaseRequest requ=null;
		UnitedRequest ureq=null;
		CmdType cmdType;
		public  X(SearchBase sb){
			this.sb=sb;
			
		}
		public  X(QueryRequest req){
			this.requ=req;
			sb=req.getSearchBase();
		}

		@Override
		public void askBegin(String tx) {
			if(requ instanceof QueryRequest)
				((QueryRequest)requ).setStart(VConvert.str2Int(tx));
		}

		@Override
		public void queryCmd(CmdType tx) throws ParseException {
			
			cmdType=tx;
			
			if(ureq!=null){
				switch(tx){
				case SEARCH:requ=new QueryRequest(sb);requ.getHeader().setType(QueryRequest.QUERY_INDEX);break;
				case GROUP:requ=new GroupRequest(sb);requ.getHeader().setType(QueryRequest.QUERY_GROUP);break;
				case DISTINCT:requ=new DistinctRequest(sb);requ.getHeader().setType(QueryRequest.QUERY_DISTINCT_INDEX);break;
				case CUBE:requ=new CubeRequest(sb);requ.getHeader().setType(QueryRequest.QUERY_CUBE);break;
				case KEYWORDS:requ=new KeyWordRequest(sb);requ.getHeader().setType(QueryRequest.QUERY_KEYWORD);break;
				case WORDCLOUD:requ=new WordCloudRequest(sb);requ.getHeader().setType(QueryRequest.QUERY_WORDCLOUD);break;
				case WAM:requ=new WamRequest(sb);requ.getHeader().setType(QueryRequest.QUERY_WAM);break;
				case CLUSTER:requ=new ClusterRequest(sb);requ.getHeader().setType(QueryRequest.QUERY_CLUSTER);break;
				default:
					throw new ParseException("unkown query type:"+tx);
				}
				ureq.createByRequest(requ);
				return;
			}
			
			switch(tx){
			case SEARCH:if(requ==null)requ=new QueryRequest(sb);requ.getHeader().setType(QueryRequest.QUERY_INDEX);break;
			case GROUP:if(requ==null)requ=new GroupRequest(sb);requ.getHeader().setType(QueryRequest.QUERY_GROUP);break;
			case DISTINCT:if(requ==null)requ=new DistinctRequest(sb);requ.getHeader().setType(QueryRequest.QUERY_DISTINCT_INDEX);break;
			case CUBE:if(requ==null)requ=new CubeRequest(sb);requ.getHeader().setType(QueryRequest.QUERY_CUBE);break;
			case KEYWORDS:if(requ==null)requ=new KeyWordRequest(sb);requ.getHeader().setType(QueryRequest.QUERY_KEYWORD);break;
			case WORDCLOUD:if(requ==null)requ=new WordCloudRequest(sb);requ.getHeader().setType(QueryRequest.QUERY_WORDCLOUD);break;
			case WAM:if(requ==null)requ=new WamRequest(sb);requ.getHeader().setType(QueryRequest.QUERY_WAM);break;
			case CLUSTER:if(requ==null)requ=new ClusterRequest(sb);requ.getHeader().setType(QueryRequest.QUERY_CLUSTER);break;
			case UNITED:if(ureq==null)ureq=new UnitedRequest(sb);break;
			}
			
		}
		@Override
		public void askNum(String tx) {
			requ.getHeader().setSchlen(VConvert.str2Int(tx));
		}
		@Override
		public void target(String fn) {
			requ.getHeader().setTargetFN(fn.toUpperCase());
		}
		@Override
		public void groupBegin(String tx) {
			requ.getHeader().setGroupBegin(VConvert.str2Long(tx));
		}
		@Override
		public void groupStep(String tx) {
			requ.getHeader().setGroupStep(VConvert.str2Long(tx));
		}
		@Override
		public void table_name(String tablename) {
			if(ureq!=null)
				ureq.getHeader().setTableName(tablename);
			else
				requ.getHeader().setTableName(tablename);
			
		}
		
		@Override
		public void orderBy(SortType tx) {
			if(requ instanceof QueryRequest){
				switch(tx){
				case time:   ((QueryRequest)requ).setOrderByTime();break;
				case rela:((QueryRequest)requ).setOrderByRela();break;
				case random:try {
						((QueryRequest)requ).setOrderByRamdom();
					} catch (Exception e) {
						e.printStackTrace();
					}break;
				case COPIES:((DistinctRequest)requ).setOrderByCopies();break;
				case time_asc:((QueryRequest)requ).setOrderByTimeAse();break;
				default:
				}
				return;
			}
			if(requ instanceof SamplingRequest){
				switch(tx){
					case time:   ((SamplingRequest)requ).setOrderByTime();break;
					case rela:((SamplingRequest)requ).setOrderByRela();break;
					case random:try {((SamplingRequest)requ).setOrderByRamdom();} catch (Exception e) {
						e.printStackTrace();
					}break;
					case time_asc:((SamplingRequest)requ).setOrderByTimeAse();break;
					default:
				}
			}
		}
		@Override
		public void orderBy(SortType type,String func){
			if(func==null) return;
			
			if(requ instanceof QueryRequest)
			switch(type){
			case field_desc:((QueryRequest)requ).setOrderByFieldDesc(func.toUpperCase());break;
			case field_asc:((QueryRequest)requ).setOrderByFieldAsc(func.toUpperCase());break;
			case heat:((QueryRequest)requ).setOrderByFormula(func);break;
			default:
			}
			
			else if(requ instanceof SamplingRequest)
				switch(type){
				case field_desc:((SamplingRequest)requ).setOrderByFieldDesc(func.toUpperCase());break;
				case field_asc:((SamplingRequest)requ).setOrderByFieldAsc(func.toUpperCase());break;
				case heat:((SamplingRequest)requ).setOrderByFormula(func);break;
				default:
				}
		}
		@Override
		public void sum(SumType type){
			if(requ instanceof QueryRequest)
			switch(type){
			case none:((QueryRequest)requ).setSumType(QueryRequest.SumType.none); break;
			case count:((QueryRequest)requ).setSumType(QueryRequest.SumType.count);break;
			case estimate:((QueryRequest)requ).setSumType(QueryRequest.SumType.estimate);break;
			}
		}
		@Override
		public void fieldSum(List<String> sumlist) throws ParseException{
			
			if(requ instanceof GroupRequest){
				try{
					((GroupRequest)requ).setSumFields4Group(sumlist);
					}catch(Exception e){
						throw new ParseException(e.getMessage());
					}
				return ;
			}
			
			if(requ instanceof CubeRequest){
				try{
					((CubeRequest)requ).setSumFields4Cube(sumlist);
					}catch(Exception e){
						throw new ParseException(e.getMessage());
					}
			}
			
			
			
		
		}
		@Override
		public void cube2f_max(String tx) {
			requ.getHeader().setCube2f_max(VConvert.str2Int(tx));
			
		}
		@Override
		public void cube2fn(String fn) {
			requ.getHeader().setCube2fn(fn.toUpperCase().getBytes());
			
		}
		@Override
		public void simhash_threshold(String tx) {
			requ.getHeader().setSimhash_threshold(VConvert.str2Byte(tx));
			
		}
		@Override
		public void miningParams(List<String> list) {
			//System.out.println("miningParams:"+list);
			switch(requ.getHeader().getType()){
			case QueryRequest.QUERY_WORDCLOUD:
			case QueryRequest.QUERY_WAM:
				if(list.size()>0) requ.getHeader().maxKeyWords=VConvert.str2Short(list.get(0));	
				if(list.size()>1) requ.getHeader().setClusterWordNumLimitPerDoc(VConvert.str2Short(list.get(1)));	
				break;
			case QueryRequest.QUERY_CLUSTER:
				if(list.size()>0) requ.getHeader().setClusterDistance(VConvert.str2Double(list.get(0)));	
				if(list.size()>1) requ.getHeader().setClustermaxloop(VConvert.str2Int(list.get(1)));	
				if(list.size()>2) requ.getHeader().setCluster_minwordnum_group(VConvert.str2Int(list.get(2)));	
				if(list.size()>3) requ.getHeader().setClusterMaxDocInGroup(VConvert.str2Short(list.get(3)));	
				if(list.size()>4) requ.getHeader().setClusterMaxGroup(VConvert.str2Short(list.get(4)));	
				if(list.size()>5) requ.getHeader().setClusterWordNumLimitPerDoc(VConvert.str2Short(list.get(5)));	
				if(list.size()>6) requ.getHeader().setClusterWordTotalMaxLimit(VConvert.str2Short(list.get(6)));	
					break;
			
			case QueryRequest.QUERY_DISTINCT_INDEX:		
				if(list.size()>0) requ.getHeader().setdCMax(VConvert.str2Int(list.get(0)));
				if(list.size()>1) {
					byte b=(byte) (VConvert.str2Bool(list.get(1))?0:1);
					if(list.size()>2) b+=(byte) (VConvert.str2Bool(list.get(2))?0:4);
					requ.getHeader().setDistinctKeyDoc(b);
				}
				break;	
			 
			}
		}
		@Override
		public void createRequest(){
			if(ureq!=null)
				requ=ureq;
			
			if(requ==null)
				requ=new QueryRequest(sb);
		}
		@Override
		public BaseRequest getRequest() {
			if(ureq!=null) return ureq;
			return requ;
		}
		@Override
		public SubCrit oneFieldCrit(String fn, OpType op, String value) throws ParseException {
			if(fn.startsWith("formula:"))
				return one_formula(fn.substring(8),op,value);
			if(fn.startsWith("join:"))
				return one_join(fn.substring(5),op,value);
		
			fn=fn.toUpperCase();
			FieldInfo info = sb.getSchema().find(fn);
			if(info==null)
				throw new ParseException("no such a field:"+fn);
			
			
			SubCrit sub = requ.createSubCrit();
			
			
			switch(op){
			case EXPRMATCH:  	oneFieldCrit_index(sub,info,value); break;
			case GREATTHAN: oneFieldCrit_greatthan(sub,info,value); break;
			case LESSTHAN:	oneFieldCrit_lessthan(sub,info,value); break;
			case EQUAL:		oneFieldCrit_equal(sub,info,value); break;
			case UNEQUAL:	oneFieldCrit_unequal(sub,info,value); break;
			case GREATEQUAL:oneFieldCrit_greatequal(sub,info,value); break;
			case LESSEQUAL:	oneFieldCrit_lessequal(sub,info,value); break;
			case COMPARE:	oneFieldCrit_equal(sub,info,value); break;
			case BETWEEN:
			case IN:
			case NOTIN:
			case FUZZYMATCH:
			case BITAND:
			case MASK_EQUAL:
			default: throw new ParseException("ERROR "+op);
			}
			
		
			return sub;
		}

		private void oneFieldCrit_lessequal(SubCrit sub, FieldInfo info,
				String value)throws ParseException {
			String fn=info.getName();
			switch(info.getType())
			{
			case FieldInfo.TYPE_HOSTSN: 
			case FieldInfo.TYPE_BYTE:
			case FieldInfo.TYPE_SHORT:
			case FieldInfo.TYPE_INT32:
			case FieldInfo.TYPE_INT32I:
			case FieldInfo.TYPE_INT24:
					try {sub.andLessEqual(fn, VConvert.str2Int(value));} catch (Exception e) {throw new ParseException(e.getMessage());} break;
			case FieldInfo.TYPE_INT64:
			case FieldInfo.TYPE_SEQUENCE:
				try {sub.andLessEqual(fn, VConvert.str2Long(value));} catch (Exception e) {throw new ParseException(e.getMessage());} break;
			case FieldInfo.TYPE_BIT:
			case FieldInfo.TYPE_BIT2:
			case FieldInfo.TYPE_BIT4:
				try {sub.andLessEqual(fn, (byte)VConvert.str2Int(value));} catch (Exception e) {throw new ParseException(e.getMessage());} break;
							

			default:throw new 	ParseException("字段["+fn+"]不支持 '<='运算");
			}
		}
		private void oneFieldCrit_greatequal(SubCrit sub, FieldInfo info,
				String value) throws ParseException{
			String fn=info.getName();
			switch(info.getType())
			{
			case FieldInfo.TYPE_HOSTSN: 
			case FieldInfo.TYPE_BYTE:
			case FieldInfo.TYPE_SHORT:
			case FieldInfo.TYPE_INT32:
			case FieldInfo.TYPE_INT32I:
			case FieldInfo.TYPE_INT24:
					try {sub.andGreatEqual(fn, VConvert.str2Int(value));} catch (Exception e) {throw new ParseException(e.getMessage());} break;
			case FieldInfo.TYPE_INT64:
			case FieldInfo.TYPE_SEQUENCE:
				try {sub.andGreatEqual(fn, VConvert.str2Long(value));} catch (Exception e) {throw new ParseException(e.getMessage());} break;
			case FieldInfo.TYPE_BIT:
			case FieldInfo.TYPE_BIT2:
			case FieldInfo.TYPE_BIT4:
				try {sub.andGreatEqual(fn, (byte)VConvert.str2Int(value));} catch (Exception e) {throw new ParseException(e.getMessage());} break;
							

			default:throw new 	ParseException("字段["+fn+"]不支持 '>='运算");
			}
		}
		private void oneFieldCrit_unequal(SubCrit sub, FieldInfo info,
				String value) throws ParseException{
			String fn=info.getName();
			switch(info.getType())
			{
			case FieldInfo.TYPE_HOSTSN: 
			case FieldInfo.TYPE_BYTE:
			case FieldInfo.TYPE_SHORT:
			case FieldInfo.TYPE_INT32:
			case FieldInfo.TYPE_INT32I:
			case FieldInfo.TYPE_INT24:
					try {sub.andUnequal(fn, VConvert.str2Int(value));} catch (Exception e) {throw new ParseException(e.getMessage());} break;
			case FieldInfo.TYPE_INT64:
			case FieldInfo.TYPE_SEQUENCE:
				try {sub.andUnequal(fn, VConvert.str2Long(value));} catch (Exception e) {throw new ParseException(e.getMessage());} break;
			case FieldInfo.TYPE_BIT:
			case FieldInfo.TYPE_BIT2:
			case FieldInfo.TYPE_BIT4:
				try {sub.andUnequal(fn, (byte)VConvert.str2Int(value));} catch (Exception e) {throw new ParseException(e.getMessage());} break;
							

			default:throw new 	ParseException("字段["+fn+"]不支持 '!='运算");
			}
		}
		private void oneFieldCrit_equal(SubCrit sub, FieldInfo info,
				String value) throws ParseException{
			String fn=info.getName();
			switch(info.getType())
			{
			case FieldInfo.TYPE_HOSTSN: 
			case FieldInfo.TYPE_BYTE:
			case FieldInfo.TYPE_SHORT:
			case FieldInfo.TYPE_INT32:
			case FieldInfo.TYPE_INT32I:
			case FieldInfo.TYPE_INT24:
					try {sub.andEqual(fn, VConvert.str2Int(value));} catch (Exception e) {throw new ParseException(e.getMessage());} break;
			case FieldInfo.TYPE_INT64:
			case FieldInfo.TYPE_SEQUENCE:
				try {sub.andEqual(fn, VConvert.str2Long(value));} catch (Exception e) {throw new ParseException(e.getMessage());} break;
			case FieldInfo.TYPE_BIT:
			case FieldInfo.TYPE_BIT2:
			case FieldInfo.TYPE_BIT4:
				try {sub.andEqual(fn, (byte)VConvert.str2Int(value));} catch (Exception e) {throw new ParseException(e.getMessage());} break;
							
			case FieldInfo.TYPE_ARTICLE:
			case FieldInfo.TYPE_BYTE16:
				try {sub.andEqual(fn, ArrayUtil.hexToByteArray(value));} catch (Exception e) {throw new ParseException(e.getMessage());} break;
				
			case FieldInfo.TYPE_VARCHAR:
			case FieldInfo.TYPE_CATEGORY:
			case FieldInfo.TYPE_KWORDS:
			case FieldInfo.TYPE_CATEVINT:
			case FieldInfo.TYPE_LABEL:
			{	
				
				   try {
					sub.andEqual(fn, value);
				   } catch (Exception e) {
					   throw new ParseException(e.getMessage());
				   }
				}	break;
				
			default:throw new 	ParseException("字段["+fn+"]不支持 '='运算");
			}
		}
		private void oneFieldCrit_lessthan(SubCrit sub, FieldInfo info,
				String value) throws ParseException {
			String fn=info.getName();
			switch(info.getType())
			{
			case FieldInfo.TYPE_HOSTSN: 
			case FieldInfo.TYPE_BYTE:
			case FieldInfo.TYPE_SHORT:
			case FieldInfo.TYPE_INT32:
			case FieldInfo.TYPE_INT32I:
			case FieldInfo.TYPE_INT24:
					try {sub.andLessThan(fn, VConvert.str2Int(value));} catch (Exception e) {throw new ParseException(e.getMessage());} break;
			case FieldInfo.TYPE_INT64:
			case FieldInfo.TYPE_SEQUENCE:
				try {sub.andLessThan(fn, VConvert.str2Long(value));} catch (Exception e) {throw new ParseException(e.getMessage());} break;
			case FieldInfo.TYPE_BIT:
			case FieldInfo.TYPE_BIT2:
			case FieldInfo.TYPE_BIT4:
				try {sub.andLessThan(fn, (byte)VConvert.str2Int(value));} catch (Exception e) {throw new ParseException(e.getMessage());} break;
							

			default:throw new 	ParseException("字段["+fn+"]不支持 '<'运算");
			}
		}
		private void oneFieldCrit_greatthan(SubCrit sub, FieldInfo info,
				String value) throws ParseException {
			String fn=info.getName();
			switch(info.getType())
			{
			
			case FieldInfo.TYPE_HOSTSN: 
			case FieldInfo.TYPE_BYTE:
			case FieldInfo.TYPE_SHORT:
			case FieldInfo.TYPE_INT32:
			case FieldInfo.TYPE_INT32I:
			case FieldInfo.TYPE_INT24:
					try {sub.andGreatThan(fn, VConvert.str2Int(value));} catch (Exception e) {throw new ParseException(e.getMessage());} break;
			case FieldInfo.TYPE_INT64:
			case FieldInfo.TYPE_SEQUENCE:
				try {sub.andGreatThan(fn, VConvert.str2Long(value));} catch (Exception e) {throw new ParseException(e.getMessage());} break;
			case FieldInfo.TYPE_BIT:
			case FieldInfo.TYPE_BIT2:
			case FieldInfo.TYPE_BIT4:
				try {sub.andGreatThan(fn, (byte)VConvert.str2Int(value));} catch (Exception e) {throw new ParseException(e.getMessage());} break;
							

			default:throw new 	ParseException("字段["+fn+"]不支持 '>'运算");
			}
		
			
		}
		private void oneFieldCrit_index(SubCrit sub, FieldInfo info,
				String value) throws ParseException {
			String fn=info.getName();
			
			switch(info.getType())
			{
			
			case FieldInfo.TYPE_TEXT:
			case FieldInfo.TYPE_ARTICLE:
					try {sub.andExprMatch(fn, value);} catch (Exception e) {throw new ParseException(e.getMessage());}
					break;
			
			default:throw new 	ParseException("字段["+fn+"]不支持搜索运算");
			}
				
			
		}
		@Override
		public SubCrit oneFieldCrit(String fn, OpType op, String beginV,
				String endV) throws ParseException {
			
			if(fn.startsWith("join:"))
				return one_join(fn.substring(5),op,beginV,endV);
			if(fn.startsWith("formula:"))
				return one_formula(fn.substring(8),op,beginV,endV);

			
			fn=fn.toUpperCase();
			
			FieldInfo info = sb.getSchema().find(fn);
			if(info==null)
				throw new ParseException("no such a field:"+fn);
			
			SubCrit sub = requ.createSubCrit();
		
			
			switch(op){
			
			case FUZZYMATCH:
				int rate=VConvert.str2Int(beginV.substring(1,beginV.length()-2));
				 try {sub.andFuzzyMatch(fn, endV, rate);} catch (Exception e) { throw new ParseException(e.getMessage());}
				return sub;
			case BITAND:
				oneFieldCrit_bitand(sub,info,beginV);
				return sub;
			case BETWEEN:
				oneFieldCrit_between(sub,info,beginV,endV);
				return sub;
			case MASK_EQUAL:
				oneFieldCrit_maskequal(sub,info,beginV,endV);
				return sub;
			}
			
			
		
			
			throw new ParseException("error op="+op);
			
			
			
			
			
		}

		private void oneFieldCrit_maskequal(SubCrit sub, FieldInfo info,
				String beginV, String endV) throws ParseException {
			String fn=info.getName();
			
			switch(info.getType())
			{
			
			case FieldInfo.TYPE_INT64:
			case FieldInfo.TYPE_SEQUENCE:
			{	long begin=VConvert.str2Long(beginV);
				long end=VConvert.str2Long(endV);
			   try {
				sub.andMaskEqual(fn, begin, end);
			   } catch (Exception e) {
				   throw new ParseException(e.getMessage());
			   }
			}	break;
			
			
			     case FieldInfo.TYPE_INT32: 
			     case FieldInfo.TYPE_INT32I:
			     case FieldInfo.TYPE_INT24: 
			     case FieldInfo.TYPE_BYTE : 
			     case FieldInfo.TYPE_SHORT :
			     {
			    	 int begin=VConvert.str2Int(beginV);
					int end=VConvert.str2Int(endV);
					   try {
						sub.andMaskEqual(fn, begin, end);
					   } catch (Exception e) {
						   throw new ParseException(e.getMessage());
					   }
			     }
			    	 break;
			     case FieldInfo.TYPE_BIT : 
			     case FieldInfo.TYPE_BIT2 :
			     case FieldInfo.TYPE_BIT4 :
			     {
			    	 int begin=VConvert.str2Int(beginV);
						int end=VConvert.str2Int(endV);
						   try {
							sub.andMaskEqual(fn, (byte)begin,(byte) end);
						   } catch (Exception e) {
							   throw new ParseException(e.getMessage());
						   }
			     }
			     break;
			     case FieldInfo.TYPE_BYTE16:
						try {sub.andMaskEqual(fn, ArrayUtil.hexToByteArray(beginV,16), ArrayUtil.hexToByteArray(endV,16));} catch (Exception e) {throw new ParseException(e.getMessage());} break;
			    default :throw new ParseException("field not support between:"+fn);
			}
		}
		private void oneFieldCrit_between(SubCrit sub, FieldInfo info,
				String beginV, String endV) throws ParseException {
			String fn=info.getName();
			
			switch(info.getType())
			{
			
			case FieldInfo.TYPE_INT64:
			case FieldInfo.TYPE_SEQUENCE:
			{	long begin=VConvert.str2Long(beginV);
				long end=VConvert.str2Long(endV);
			   try {
				sub.andBetween(fn, begin, end);
			   } catch (Exception e) {
				   throw new ParseException(e.getMessage());
			   }
			}	break;
			
			case FieldInfo.TYPE_HOSTSN: 
			     case FieldInfo.TYPE_INT32: 
			     case FieldInfo.TYPE_INT32I:
			     case FieldInfo.TYPE_INT24: 
			     case FieldInfo.TYPE_BYTE : 
			     case FieldInfo.TYPE_SHORT :
			     {
			    	 int begin=VConvert.str2Int(beginV);
					int end=VConvert.str2Int(endV);
					   try {
						sub.andBetween(fn, begin, end);
					   } catch (Exception e) {
						   throw new ParseException(e.getMessage());
					   }
			     }
			    	 break;
			     case FieldInfo.TYPE_BIT : 
			     case FieldInfo.TYPE_BIT2 :
			     case FieldInfo.TYPE_BIT4 :
			     {
			    	 int begin=VConvert.str2Int(beginV);
						int end=VConvert.str2Int(endV);
						   try {
							sub.andBetween(fn, (byte)begin,(byte) end);
						   } catch (Exception e) {
							   throw new ParseException(e.getMessage());
						   }
			     }
			     break;
			
			    default :throw new ParseException("field not support between:"+fn);
			}
			
		}
		private void oneFieldCrit_bitand(SubCrit sub, FieldInfo info,
				String beginV) throws ParseException {
			String fn=info.getName();
			
			switch(info.getType())
			{
			
			case FieldInfo.TYPE_INT64:
			case FieldInfo.TYPE_SEQUENCE:
			{	long begin=VConvert.str2Long(beginV);
			   try {
				sub.andBitAnd(fn, begin);
			   } catch (Exception e) {
				   throw new ParseException(e.getMessage());
			   }
			}	break;
			
			
			     case FieldInfo.TYPE_INT32: 
			     case FieldInfo.TYPE_INT32I:
			     case FieldInfo.TYPE_INT24: 
			     case FieldInfo.TYPE_BYTE : 
			     case FieldInfo.TYPE_SHORT :
			     {
			    	 int begin=VConvert.str2Int(beginV);
					   try {
						   sub.andBitAnd(fn, begin);
					   } catch (Exception e) {
						   throw new ParseException(e.getMessage());
					   }
			     }
			    	 break;
			     case FieldInfo.TYPE_BIT : 
			     case FieldInfo.TYPE_BIT2 :
			     case FieldInfo.TYPE_BIT4 :
			     {
			    	 int begin=VConvert.str2Int(beginV);
						   try {
							   sub.andBitAnd(fn, begin);
						   } catch (Exception e) {
							   throw new ParseException(e.getMessage());
						   }
			     }
			     break;
			
			     case FieldInfo.TYPE_BYTE16:
						try {sub.andBitAnd(fn, ArrayUtil.hexToByteArray(beginV,16));} catch (Exception e) {throw new ParseException(e.getMessage());} break;
			     
			     
			    default :throw new ParseException("field not support between:"+fn);
			}
		}
		@Override
		public SubCrit oneFieldCrit(String fn, String op, List<String> value) throws ParseException {
			
			
			if(fn.startsWith("formula:"))
				return one_formula(fn.substring(8),op,value);
			
			fn=fn.toUpperCase();
			
			if(op==null )
				throw new ParseException("ERROR OP:"+op);
			
			FieldInfo info = sb.getSchema().find(fn);
			if(info==null)
				throw new ParseException("no such a field:"+fn);
			
			SubCrit sub = requ.createSubCrit();
		
			if(op.equalsIgnoreCase("in"))
				oneFieldCrit_in(sub,info,value);
			else if(op.equalsIgnoreCase("notin"))
				oneFieldCrit_notin(sub,info,value);
			else 
				throw new ParseException("ERROR OP:"+op);
			
			
			
			
			
			return sub;
			
			
		}
		private void oneFieldCrit_notin(SubCrit sub, FieldInfo info,
				List<String> value) throws ParseException {
			String fn=info.getName();
			
			switch(info.getType())
			{
			
//			case FieldInfo.TYPE_TEXT:
//			case FieldInfo.TYPE_ARTICLE:
			case FieldInfo.TYPE_VARCHAR:
			case FieldInfo.TYPE_CATEGORY:
			case FieldInfo.TYPE_KWORDS:
			case FieldInfo.TYPE_CATEVINT:
			case FieldInfo.TYPE_LABEL:
			{	
				
				   try {
					sub.andNotIn(fn,value.toArray(new String[value.size()]));
				   } catch (Exception e) {
					   throw new ParseException(e.getMessage());
				   }
				}	break;
			case FieldInfo.TYPE_ARTICLE:
			case FieldInfo.TYPE_BYTE16:
			{	
				
				   try {
					sub.andNotIn(fn,ArrayUtil.toBytesArray(value));
				   } catch (Exception e) {
					   throw new ParseException(e.getMessage());
				   }
				}	break;
			case FieldInfo.TYPE_INT64:
			case FieldInfo.TYPE_SEQUENCE:
			{	
				
				
				
			   try {
				   
				sub.andNotIn(fn, ArrayUtil.toLongArray(value));
			   } catch (Exception e) {
				   throw new ParseException(e.getMessage());
			   }
			}	break;
			
			case FieldInfo.TYPE_HOSTSN: 
			     case FieldInfo.TYPE_INT32: 
			     case FieldInfo.TYPE_INT32I:
			     case FieldInfo.TYPE_INT24: 
			     case FieldInfo.TYPE_BYTE : 
			     case FieldInfo.TYPE_SHORT :
			     {
			    		
					   try {
						sub.andNotIn(fn, ArrayUtil.toIntArray(value));
					   } catch (Exception e) {
						   throw new ParseException(e.getMessage());
					   }
			     }
			    	 break;
			     case FieldInfo.TYPE_BIT : 
			     case FieldInfo.TYPE_BIT2 :
			     case FieldInfo.TYPE_BIT4 :
			     {
			    		
					   try {
						sub.andNotIn(fn, ArrayUtil.toByteArray(value));
					   } catch (Exception e) {
						   throw new ParseException(e.getMessage());
					   }
			     }
			     break;
			
			    default :throw new ParseException("field not support in operator:"+fn);
			}
		}
		private void oneFieldCrit_in(SubCrit sub, FieldInfo info,
				List<String> value) throws ParseException {
			String fn=info.getName();
			
			switch(info.getType())
			{
			
//			case FieldInfo.TYPE_TEXT:
//			case FieldInfo.TYPE_ARTICLE:
			case FieldInfo.TYPE_VARCHAR:
			case FieldInfo.TYPE_CATEGORY:
			case FieldInfo.TYPE_KWORDS:
			case FieldInfo.TYPE_CATEVINT:
			case FieldInfo.TYPE_LABEL:
			{	
				
				   try {
					sub.andIn(fn,value.toArray(new String[value.size()]));
				   } catch (Exception e) {
					   throw new ParseException(e.getMessage());
				   }
				}	break;
			case FieldInfo.TYPE_ARTICLE:
			case FieldInfo.TYPE_BYTE16:
			{	
				
				   try {
					sub.andIn(fn,ArrayUtil.toBytesArray(value));
				   } catch (Exception e) {
					   throw new ParseException(e.getMessage());
				   }
				}	break;
			case FieldInfo.TYPE_INT64:
			case FieldInfo.TYPE_SEQUENCE:
			{	
				
				
				
			   try {
				   
				sub.andIn(fn, ArrayUtil.toLongArray(value));
			   } catch (Exception e) {
				   throw new ParseException(e.getMessage());
			   }
			}	break;
			
			 case FieldInfo.TYPE_HOSTSN: 
			     case FieldInfo.TYPE_INT32: 
			     case FieldInfo.TYPE_INT32I:
			     case FieldInfo.TYPE_INT24: 
			     case FieldInfo.TYPE_BYTE : 
			     case FieldInfo.TYPE_SHORT :
			     {
			    		
					   try {
						sub.andIn(fn, ArrayUtil.toIntArray(value));
					   } catch (Exception e) {
						   throw new ParseException(e.getMessage());
					   }
			     }
			    	 break;
			     case FieldInfo.TYPE_BIT : 
			     case FieldInfo.TYPE_BIT2 :
			     case FieldInfo.TYPE_BIT4 :
			     {
			    		
					   try {
						sub.andIn(fn, ArrayUtil.toByteArray(value));
					   } catch (Exception e) {
						   throw new ParseException(e.getMessage());
					   }
			     }
			     break;
			 
			 		
			    default :throw new ParseException("field not support in operator:"+fn);
			}
		}
		@Override
		public void where(SubCrit subt) {
			requ.mergeAnd(subt);
			
		}
		@Override
		public RunResult runRequest(SearchClient ss) throws Exception {
			
			if(ureq!=null)
				return  new RunResult(ureq,CmdType.UNITED,ss.unitedQuery(ureq));	
			
			switch(cmdType){
			
			case SEARCH:	return new RunResult(requ,cmdType,ss.query((QueryRequest)requ));
			case GROUP:		return new RunResult(requ,cmdType,ss.group((GroupRequest)requ));
			case DISTINCT:	return new RunResult(requ,cmdType,ss.distinct((DistinctRequest)requ));
			case CUBE:		return new RunResult(requ,cmdType,ss.cube((CubeRequest)requ));
			case KEYWORDS:	return new RunResult(requ,cmdType,ss.collectKeyWords((KeyWordRequest)requ));
			case WORDCLOUD:	return new RunResult(requ,cmdType,ss.wordcloud((WordCloudRequest)requ));
			case WAM:		return new RunResult(requ,cmdType,ss.wam((WamRequest)requ));
			case CLUSTER:	return new RunResult(requ,cmdType,ss.cluster((ClusterRequest)requ));
			//case UNITED:	return new RunResult(ureq,cmdType,ss.unitedQuery(ureq));	
			}
			return null;
		}
		
		private SubCrit one_join(String join, OpType op, String value) throws ParseException {
			//System.out.println("join:"+join+" "+op+" "+value);
			if(op!=OpType.EXPRMATCH)
				throw new ParseException("ERROR "+op);
			
			SubCrit sub = requ.createSubCrit();
			try {sub.andJoinExprMatch(join.toUpperCase().split(","), value);} catch (Exception e) { throw new ParseException(e.getMessage());}
		
			return sub;
		}
		private SubCrit one_join(String join, OpType op, String beginV,	String endV) throws ParseException {
			//System.out.println("join:"+join+" "+op+" "+beginV+","+endV);
			if(op!=OpType.FUZZYMATCH)
				throw new ParseException("ERROR "+op);
			
			SubCrit sub = requ.createSubCrit();
			int rate=VConvert.str2Int(beginV.substring(1,beginV.length()-2));
			try {sub.andJoinFuzzyMatch(join.toUpperCase().split(","), endV, rate);} catch (Exception e) { throw new ParseException(e.getMessage());}
		
			return sub;
		}
		private SubCrit one_formula(String formula, OpType op, String value) throws ParseException{
			//System.out.println("formula:"+formula+" "+op+" "+value);
		
			SubCrit sub = requ.createSubCrit();
			try {
				switch(op){
				case GREATTHAN: sub.andFormulaGreatThan(formula, VConvert.str2Double(value));return sub;
				case LESSTHAN:	sub.andFormulaLessThan(formula, VConvert.str2Double(value));return sub;
				case EQUAL:		sub.andFormulaEqual(formula, VConvert.str2Double(value));return sub;
				case UNEQUAL:	sub.andFormulaUnequal(formula, VConvert.str2Double(value));return sub;
				case GREATEQUAL:sub.andFormulaGreatEqual(formula, VConvert.str2Double(value));return sub;
				case LESSEQUAL:	sub.andFormulaLessEqual(formula, VConvert.str2Double(value));return sub;
				case COMPARE:	sub.andFormulaEqual(formula, VConvert.str2Double(value));return sub;
				
				case EXPRMATCH:  	
				case BETWEEN:
				case IN:
				case NOTIN:
				case FUZZYMATCH:
				case BITAND:
				case MASK_EQUAL:
				}
				
			} catch (Exception e) {throw new ParseException(e.getMessage());} 
	
			throw new ParseException("ERROR "+op);
		}
		
		private SubCrit one_formula(String formula, OpType op, String beginV,String endV) throws ParseException{
			//System.out.println("formula:"+formula+" "+op+" "+beginV+","+endV);
			if(op!=OpType.BETWEEN)
				throw new ParseException("ERROR "+op);
			
			SubCrit sub = requ.createSubCrit();
			try {sub.andFormulaBetween(formula,  VConvert.str2Double(beginV),  VConvert.str2Double(endV));} catch (Exception e) { throw new ParseException(e.getMessage());}
			return sub;
		}
		
		private SubCrit one_formula(String formula, String op, List<String> values)throws ParseException {
			//System.out.println("formula:"+formula+" "+op+" "+values);
			
			if(op==null )
				throw new ParseException("ERROR OP:"+op);
			
			double[] vs=new double[values.size()];
			int n=0;
			for(String v:values){
				vs[n++]=VConvert.str2Double(v);
			}
			
			SubCrit sub = requ.createSubCrit();
		
			if(op.equalsIgnoreCase("in"))
				try {sub.andFormulaIn(formula,  vs);} catch (Exception e) { throw new ParseException(e.getMessage());}
			else if(op.equalsIgnoreCase("notin"))
				try {sub.andFormulaNotIn(formula,  vs);} catch (Exception e) { throw new ParseException(e.getMessage());}
			else 
				throw new ParseException("ERROR OP:"+op);
			
			return sub;
		}
	}

	
	public static class RunResult{
		
		CmdType cmdType;
		Object result;
		BaseRequest requ;
		public RunResult(BaseRequest req,CmdType cmdType,Object result){
			this.requ=req;
			this.cmdType=cmdType;
			this.result=result;
		}
		
		
		public CmdType getCmdType() {
			return cmdType;
		}
		public Object getResult() {
			return result;
		}


		public BaseRequest getRequest() {
			return requ;
		}
		
	}
	
	public static class PSubCrit extends QueryRequest{
		
		
		String label;
		public PSubCrit(String label) {
			this.label=label;
		}

		@Override
		public SubCrit createSubCrit() {
			return new PSubTerm(this);
		}

		@Override
		public String toString() {
			return label;
		}

		public  class PSubTerm extends SubCrit{

			protected PSubTerm(QueryRequest request) {
				super(request);
			}

			@Override
			public String toString() {
				return label;
			}

			@Override
			public void toStringBuffer(StringBuffer strb) {
				strb.append(label) ;
			}

			@Override
			public SubCrit and(Criteria bt) {
				label= label +" .and. "+bt.toString();
				System.out.println(label);
				return super.and(bt);
			}

			@Override
			public SubCrit or(Criteria bt) {
				label= label +" .or. "+bt.toString();
				System.out.println(label);
				return super.or(bt);
			}

			@Override
			public SubCrit andNot(Criteria bt) {
				label= label +" .and not. "+bt.toString();
				System.out.println(label);
				return super.andNot(bt);
			}

			@Override
			public SubCrit orNot(Criteria bt) {
				label= label +" .or not. "+bt.toString();
				System.out.println(label);
				return super.orNot(bt);
			}
			
		}
		
	
		
	}
	

	public abstract void askBegin(String image);


	public abstract void queryCmd(CmdType search) throws ParseException;


	public abstract void askNum(String image);


	public abstract void target(String image);


	public abstract void groupBegin(String image);


	public abstract void groupStep(String image);


	public abstract void orderBy(SortType rela);

	public abstract void orderBy(SortType fieldAsc,String func);


	public abstract void sum(SumType estimate);


	public abstract void fieldSum(List<String> sumlist) throws ParseException;


	public abstract void createRequest();
	public abstract SubCrit oneFieldCrit(String image, OpType op, String value)throws ParseException;
	public abstract SubCrit oneFieldCrit(String image, OpType between, String beginV,String endV) throws ParseException ;
	public abstract SubCrit oneFieldCrit(String image, String op, List<String> value) throws ParseException;

	public abstract void where(SubCrit subt);

	public abstract void cube2f_max(String image) ;
	public abstract void cube2fn(String image);
	public abstract void miningParams(List<String> list);
	public abstract void simhash_threshold(String image);
	public abstract RunResult runRequest(SearchClient ss) throws Exception;
	public abstract void table_name(String image);

	/**
	 * sql:SEARCH [0,20] orderby=heat('IN+BJ') sum= count where ((TX : 'BY' AND RQ > 0 AND BI between 1,2) AND (((BJ = 1) AND NOT (AU = '分林会''员涉,abc%')) OR (BK = 2))) AND NOT (AL in '分林会''员涉,abc%')
	 * */
	public static BaseRequest fromSql(SearchBase ss,String sql) throws Exception{
		RequestParser tp=new RequestParser(new StringReader(sql));
		 RequestBuilder tb= new RequestBuilder.X(ss);
        tp.fillTo(tb);
        return tb.getRequest();
	}
	
	public static BaseRequest fromSql(RequestBuilder tb,String sql) throws Exception{
		RequestParser tp=new RequestParser(new StringReader(sql));
	    tp.fillTo(tb);
        return tb.getRequest();
	}
	/**
	 * sql:((TX : 'BY' AND RQ > 0 AND BI between 1,2) AND (((BJ = 1) AND NOT (AU = '分林会''员涉,abc%')) OR (BK = 2))) AND NOT (AL in '分林会''员涉,abc%')
	 * */
	public static BaseRequest fromWhere(QueryRequest  blank_term,String sql) throws Exception{
		RequestParser tp=new RequestParser(new StringReader(sql));
		 RequestBuilder tb= new RequestBuilder.X(blank_term);
        tp.fillOnlyWhereTo(tb);
        return tb.getRequest();
	}
	/**
	 * sql:((TX : 'BY' AND RQ > 0 AND BI between 1,2) AND (((BJ = 1) AND NOT (AU = '分林会''员涉,abc%')) OR (BK = 2))) AND NOT (AL in '分林会''员涉,abc%')
	 * */
	public static BaseRequest fromWhere(SearchBase ss,String sql) throws Exception{
		RequestParser tp=new RequestParser(new StringReader(sql));
		 RequestBuilder tb= new RequestBuilder.X(ss);
        tp.fillOnlyWhereTo(tb);
        return tb.getRequest();
	}


	

	public static RunResult runSql(SearchClient ss,String sql) throws Exception{
		RequestParser tp=new RequestParser(new StringReader(sql));
		 RequestBuilder tb= new RequestBuilder.X(ss);
        tp.fillTo(tb);
        return tb.runRequest(ss);
	}


	

	
	


	




	





}
