package cn.sowjz.search.core.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import cn.sowjz.search.common.VConvert;
import cn.sowjz.search.core.db.FieldInfo;
import cn.sowjz.search.core.db.Schema;
import cn.sowjz.search.core.db.SchemaUtil;
import cn.sowjz.search.core.doc.Doc;


public class DocToMap {

	Schema schema;
	public DocToMap(Schema schema)
	{
		this.schema=schema;
	}
	/**
	 * searchlib_config: C:\\ISearch\\db-ok\\searchlib.config
	 * */
	public DocToMap(String searchlib_config) throws Exception
	{
		this.schema=SchemaUtil.loadFromFile(searchlib_config);
	}
	ThreadLocal<SimpleDateFormat> sdf=new ThreadLocal<SimpleDateFormat>(){

		@Override
		protected SimpleDateFormat initialValue() {
			return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		}
		
	};
	
	public Map<String,String> toMap(Doc a){
		Map<String,String> m=new HashMap<String,String>();
		
		for(int i=0;i<schema.fieldNum();i++)
		{
			FieldInfo fi=schema.get(i);
			switch(fi.getType())
			{
			case FieldInfo.TYPE_SEQUENCE:
		   	{
				 long v=  a.getAslong(fi.getName());
				 if(v!=0)
				 	 m.put(fi.getName(), String.valueOf(v));
				 	 
		   	}
			 break;   
		   case FieldInfo.TYPE_ARTICLE:
		   case FieldInfo.TYPE_KWORDS:
		   case FieldInfo.TYPE_TEXT:
		   case FieldInfo.TYPE_VARCHAR:	   
		   case FieldInfo.TYPE_CATEGORY:
		   case FieldInfo.TYPE_CATEVINT:
		   case FieldInfo.TYPE_CLOB:
		   case FieldInfo.TYPE_LABEL:
		   {
			  String v=a.getAsString(fi.getName());
			  if(v!=null && v.length()>0)
				  m.put(fi.getName(), v);
		   }   
			   break;
		   case FieldInfo.TYPE_BYTE16:	   
		   case FieldInfo.TYPE_BINARY:
		   {
			   byte[] v=a.getAsbyteArray(fi.getName());
			   if(v!=null)
				   m.put(fi.getName(), VConvert.byteArrayToHex(v, 0, v.length));
		   }
			   break;
		   case FieldInfo.TYPE_BIT:
		   case FieldInfo.TYPE_BIT2:
		   case FieldInfo.TYPE_BIT4:
			   {
				   String v=a.getAsString(fi.getName());
					  if(v!=null && v.length()>0)
						  m.put(fi.getName(), v);
			   }
			   break;
		   case FieldInfo.TYPE_BYTE:
		   case FieldInfo.TYPE_SHORT:	   
		   case FieldInfo.TYPE_INT32:
		   case FieldInfo.TYPE_INT32I:
		   case FieldInfo.TYPE_INT24:
		   		{
		   			if(fi.isTime())
		   			{
		   				Date v=a.getAsDate(fi.getName());
		   				if(v!=null)
		   					m.put(fi.getName(), sdf.get().format(v));
		   			}else
		   			{	
		   		 String v=a.getAsString(fi.getName());
				  if(v!=null && v.length()>0)
					  m.put(fi.getName(), v);
		   			}
		   		}
			   break;
		   case FieldInfo.TYPE_INT64:
	   			{
	   				if(fi.isTime())
		   			{
		   				Date v=a.getAsDate(fi.getName());
		   				if(v!=null)
		   					m.put(fi.getName(), sdf.get().format(v));
		   			}else
		   			{	
		   					long v=a.getAslong(fi.getName());
		   					if(v!=0)
		   						m.put(fi.getName(), String.valueOf(v));
		   			}
			   	} 
	   			break;
		  
			}
		}	
		return m;
	}
}
