package cn.sowjz.search.core.util;

import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import cn.sowjz.search.common.VConvert;
import cn.sowjz.search.core.SearchBase;
import cn.sowjz.search.core.db.FieldInfo;
import cn.sowjz.search.core.db.Schema;
import cn.sowjz.search.core.doc.Doc;

public class DocBuilder {
	static protected Log log = LogFactory.getLog(DocBuilder.class);
	
	SearchBase ss;
	DocValueHelper dvHelper; 
	ThreadLocal<SimpleDateFormat> sdf=new ThreadLocal<SimpleDateFormat>(){

		@Override
		protected SimpleDateFormat initialValue() {
			return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		}
	};
	Map<String,FieldInfo> fmap=new HashMap<String,FieldInfo>();
	public DocBuilder(SearchBase ss)
	{
		this.ss=ss;
		
		Schema schema=ss.getSchema();
		for(int i=0;i<schema.fieldNum();i++)
		{
			FieldInfo fi=schema.get(i);
			fmap.put(fi.getName(), fi);
		}
		dvHelper=new DocValueHelper();
	}
	
	
	public  Doc fromMap(Map<String,String>map)throws Exception
	{
		if(map==null)
			return null;
		
		Doc a=new Doc(ss);
	
		for(Entry<String,String> en: map.entrySet())
		{
			
			String fn=en.getKey().toUpperCase();
			FieldInfo fi=fmap.get(fn);
			if(fi==null)
				continue;
			
			String vstr=en.getValue();
			
			switch (fi.getType())
			{
			   case FieldInfo.TYPE_SEQUENCE:
			   	{
				   if(!fi.isNativeID())
					   a.setValue(fi.getName(), VConvert.str2Long(vstr));
			   	}
				 break;   
			   case FieldInfo.TYPE_ARTICLE:
			   case FieldInfo.TYPE_KWORDS:
			   case FieldInfo.TYPE_TEXT:
			   case FieldInfo.TYPE_VARCHAR:	   
			   case FieldInfo.TYPE_CATEGORY:
			   case FieldInfo.TYPE_CATEVINT:
			   case FieldInfo.TYPE_CLOB:
			   case FieldInfo.TYPE_LABEL:
				   a.setValue(fi.getName(), vstr);
				   break;
			   
			   case FieldInfo.TYPE_BIT:
			   case FieldInfo.TYPE_BIT2:
			   case FieldInfo.TYPE_BIT4:
				   {
					   Integer vid=ss.getFieldEnumId(fi.getName(), vstr.trim());
					   if(vid!=null)
						   a.setValue(fi.getName(),(byte)vid.intValue());
					   else
						   a.setValue(fi.getName(), VConvert_str2Byte(vstr,fi));
				   }
				   break;
			   case FieldInfo.TYPE_BYTE:
			   case FieldInfo.TYPE_SHORT:	   
			   case FieldInfo.TYPE_INT32:
			   case FieldInfo.TYPE_INT32I:
			   case FieldInfo.TYPE_INT24:
			   		{
			   			
			   			if(fi.isTime())
			   			{	
							if(vstr.equalsIgnoreCase("now"))
								a.setValue(fi.getName(), (int)(System.currentTimeMillis()/1000) );
							else if(vstr.indexOf("-")>0)
					   			a.setValue(fi.getName(),sdf_parse(vstr,sdf.get(),fi)  );
			   				else	   
			   					a.setValue(fi.getName(),dvHelper.timeToInt32(vstr, fi.isUnsign()));
			   			}
			   			else {
			   				Integer vid=ss.getFieldEnumId(fi.getName(), vstr.trim());
							if(vid!=null)
								   a.setValue(fi.getName(),vid.intValue());
							else 
								a.setValue(fi.getName(),VConvert_str2Int(vstr,fi) );
			   			}	
			   		}
				   break;
			   case FieldInfo.TYPE_INT64:
		   			{
					   if(fi.isTime())
					   {
						   if(vstr.equalsIgnoreCase("now"))
								a.setValue(fi.getName(), System.currentTimeMillis() );
							else if(vstr.indexOf("-")>0)
							   a.setValue(fi.getName(),sdf_parse(vstr,sdf.get(),fi));
						   else	   
							   a.setValue(fi.getName(), VConvert_date2Long(vstr,fi));
					   }else
						   a.setValue(fi.getName(), VConvert_str2Long(vstr,fi));
				   	} 
		   			break;
			   case FieldInfo.TYPE_BINARY:
			   case FieldInfo.TYPE_BYTE16:
			     {
			    	 a.setValue(fi.getName(),VConvert.hexToByteArray(vstr));
			     }			  
			}
		}	
		return a;
	}


	protected long VConvert_date2Long(String vstr, FieldInfo fi) {
		try{ return dvHelper.timeTolong(vstr);}
		catch(Exception e)
		{
			log.error("str2Long("+vstr+") failed for "+fi.getName()+" : "+e.toString());
			e.printStackTrace();
		}
		return 0l;
	}

	protected long VConvert_str2Long(String vstr, FieldInfo fi) {
		try{ return VConvert.str2Long(vstr);}
		catch(Exception e)
		{
			log.error("str2Long("+vstr+") failed for "+fi.getName()+" : "+e.toString());
			e.printStackTrace();
		}
		return 0l;
	}

	protected int VConvert_str2Int(String vstr, FieldInfo fi) {
		try{ return VConvert.str2Int(vstr);}
		catch(Exception e)
		{
			log.error("str2Int("+vstr+") failed for "+fi.getName()+" : "+e.toString());
			e.printStackTrace();
		}
		return 0;
	}


	


	protected long sdf_parse(String vstr, SimpleDateFormat simpleDateFormat,
			FieldInfo fi) {
		try{ return simpleDateFormat.parse(vstr).getTime();}
		catch(Exception e)
		{
			log.error("str2Byte("+vstr+") failed for "+fi.getName()+" : "+e.toString());
			e.printStackTrace();
		}
		return 0l;
	}


	protected byte VConvert_str2Byte(String vstr, FieldInfo fi) {
		try
		{	return VConvert.str2Byte(vstr);
		
		}catch(Exception e)
		{
			log.error("str2Byte("+vstr+") failed for "+fi.getName()+" : "+e.toString());
		}
		return (byte)0;
	}
}
