package cn.sowjz.search.core.server.state;

import java.io.UnsupportedEncodingException;
import java.util.Date;

import cn.sowjz.search.common.VConvert;

public class ServerRegisterState
{
	private String company;

	private Date regDate;

	public ServerRegisterState()
	{
	}

	/**
	 * @return Returns the company.
	 */
	public String getCompany()
	{
		return company;
	}

	/**
	 * @param company The company to set.
	 */
	public void setCompany(String company)
	{
		this.company = company;
	}

	/**
	 * @return Returns the regDate.
	 */
	public Date getRegDate()
	{
		return regDate;
	}

	/**
	 * @param regDate The regDate to set.
	 */
	public void setRegDate(Date regDate)
	{
		this.regDate = regDate;
	}

	public int byte2Me(byte[] buf, int start, String charset) throws UnsupportedEncodingException
	{
		int start_bak = start;

		int len = VConvert.bytes2Int(buf, start);
		start += 4;
		this.company = new String(buf, start, len, charset);
		start += len;

		this.regDate = new Date(VConvert.bytes2Int(buf, start) * 1000L);
		start += 4;

		return start - start_bak;
	}

	@Override
	public String toString()
	{
		StringBuffer strb = new StringBuffer();
		strb.append("Company  name=").append(this.company).append("\n");
		strb.append("Register time=").append(this.regDate.getTime()).append("\n");
		return strb.toString();
	}
}
