package cn.sowjz.search.core.query.response;

import java.util.ArrayList;
import java.util.List;

import cn.sowjz.search.common.VConvert;
import cn.sowjz.search.core.SearchBase;
import cn.sowjz.search.core.db.FieldInfo;

public class WordCloudResponse {

	private SearchBase ss;
	
	int wordnum;
	List<DmkWord> wordlist;
	
	int doc_total;
	int total;
	int doc_num;
	byte[] databuf;
	
	public WordCloudResponse(SearchBase ss)
	{
		this.ss=ss;
	}
	public int bytes2Me(byte[] buf) throws Exception{
		return bytes2Me(buf,0);
	}
	public int bytes2Me(byte[] buf,int start) throws Exception
	{
		databuf=buf;
		
		String charset = ss.feedinfo.getCharset();

	

		wordnum = VConvert.bytes2Int(buf, start);
		start += 4;
		
		doc_total = VConvert.bytes2Int(buf, start);
		start += 4;
		total = VConvert.bytes2Int(buf, start);
		start += 4;
		doc_num = VConvert.bytes2Int(buf, start);
		start += 4;
		
		wordlist= new ArrayList<DmkWord>();

		String fn = new String(buf, start, 2, charset);
		start += 2;
		FieldInfo info = ss.getSchema().find(fn);
		if (info == null)
			throw new Exception("The field named : " + fn + " is not exist. ");

		for (int i = 0; i < wordnum; i++)
		{
			DmkWord w = new DmkWord();
			start += w.byte2Me(buf, start, info, charset);
			wordlist.add(w);
		}

		
		return start;
		
	}
	public String toString()
	{
		StringBuffer strb=new StringBuffer();
		strb.append("word cloud:\n");
		strb.append("  doc total=").append(total).append("\n");
		strb.append("  doc number=").append(doc_num).append("\n");
		strb.append("  word number=").append(wordnum).append("\n");
		for(int i=0;i<wordnum;i++)
			strb.append(i).append("\t").append(wordlist.get(i)).append("\n");
		return strb.toString();
	}
	public SearchBase getSs() {
		return ss;
	}
	public int getWordnum() {
		return wordnum;
	}
	public List<DmkWord> getWordlist() {
		return wordlist;
	}
	public DmkWord getWord(int no)
	{
		if(no<wordnum)
			return (DmkWord) wordlist.get(no);
		return null;
	}
	public int getDocTotal()
	{
		return doc_total;
	}
	public int getDocNum()
	{
		return doc_num;
	}
	public byte[] getDataBuf() {
		
		return databuf;
	}
}
